% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_color_ranges.R
\name{sphericalRange}
\alias{sphericalRange}
\title{Find pixels within a target color range defined by a center and search radius}
\usage{
sphericalRange(pixel.array, center, radius, target.color = "green",
  main = "", color.pixels = TRUE, plotting = TRUE)
}
\arguments{
\item{pixel.array}{An image represented as a 3D array (as read in by
\code{\link[jpeg]{readJPEG}}, \code{\link[png]{readPNG}}, or
\code{\link[colordistance]{loadImage}}) in which to change pixel colors.}

\item{center}{A single color (RGB triplet) around which to search. RGB range
0-1 (not 0-255).}

\item{radius}{A value between 0 and 1 specifying the size of the area around
\code{center} to search.}

\item{target.color}{Color with which to replace specified pixels. Can be
either a an RGB triplet or one of the colors listed by
\code{\link[grDevices]{colors}}.}

\item{main}{Optional title to display for image.}

\item{color.pixels}{Logical. Should a diagnostic image with pixels changed to
\code{target.color} be returned?}

\item{plotting}{Logical. Should output be plotted in the plot window?}
}
\value{
A list with the following elements:
\itemize{
  \item \code{pixel.idx}: Coordinates of pixels within color range.
  \item \code{img.fraction}: Proportion of the image within color range.
  \item \code{original.img}: The original RGB array.
  \item \code{indicator.img}: If \code{color.pixels = TRUE}, RGB array with
  color-swapped pixels.
}
}
\description{
Searches for pixels within a radius of a single color. Draws a sphere around
a region of color space in which to search for pixels.
}
\details{
\code{lower} and \code{upper} should be vectors of length 3 in a 0-1 range,
in the order R-G-B. For example, the upper bounds for white would be c(1, 1,
1), and the lower bounds might be c(0.8, 0.8, 0.8). This would search for all
pixels where the red value, blue value, AND green value are all between 0.8
and 1.
}
\examples{
# Target color: change all of the red flowers to turquoise
flowers <- jpeg::readJPEG(system.file("extdata", "flowers.jpg", package =
"countcolors"))

# Red:
center <- c(255, 75, 75) / 255

# Setting the radius too low:
red.flowers <- countcolors::sphericalRange(flowers, center = center, radius =
0.05, target.color = "turquoise")

# Setting the radius too high:
red.flowers <- countcolors::sphericalRange(flowers, center = center, radius =
0.4, target.color = "turquoise")

# Setting the radius just right:
red.flowers <- countcolors::sphericalRange(flowers, center = center, radius =
0.2, target.color = "turquoise")

}
