% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{polypeptide}
\alias{polypeptide}
\alias{Polypeptides_Carrier_Drug}
\alias{Polypeptides_Enzyme_Drug}
\alias{Polypeptide_Target_Drug}
\alias{Polypeptides_Transporter_Drug}
\title{Polypeptide}
\format{
a tibble with 20 variables:
\describe{
  \item{id}{\href{https://www.uniprot.org/}{Universal Protein Resource
  (UniProt) identifier}}
  \item{source}{Specifies whether the identified polypeptide ID is
  associated with any of the following UniProt knowledge bases:
  Swiss-Prot, which is manually annotated and reviewed, or TrEMBL,
  which is automatically annotated and not reviewed.}
  \item{name}{}
  \item{general_function}{General summary of the physiological function of
  the polypeptide}
  \item{specific_function}{A more specific description of the polypeptide’s
   physiological function within the cell.}
  \item{gene_name}{The short name commonly associated with the associated
   gene. Eg. PTGS1.}
  \item{locus}{The specific chromosomal location or position of the gene’s
   sequence on a chromosome.}
  \item{cellular_location}{The cellular location of the polypeptide.}
  \item{transmembrane_regions}{Areas of the polypeptide sequence that span
   a biological membrane.}
  \item{signal_regions}{Location of any signal peptides within the
   polypeptide sequence.}
  \item{theoretical_pi}{Theoretical isoelectric point.}
  \item{molecular_weight}{The molecular weight of the polypeptide.}
  \item{chromosome_location}{The chromosomal location of the polypeptide
  gene}
  \item{organism}{The organism in which this polypeptide functions.}
  \item{organism_ncbi_taxonomy_id}{}
  \item{amino_acid_sequence}{The amino acid sequence of the polypeptide}
  \item{amino_acid_format}{}
  \item{gene_sequence}{The sequence of the associated gene.}
  \item{gene_format}{}
  \item{parent_key}{drugbank id}
}

An object of class \code{spec_tbl_df} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 3 rows and 20 columns.

An object of class \code{spec_tbl_df} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 35 rows and 20 columns.

An object of class \code{spec_tbl_df} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 50 rows and 20 columns.

An object of class \code{spec_tbl_df} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 17 rows and 20 columns.
}
\source{
\href{https://docs.drugbankplus.com/xml/}{Drugbank Documentation}
}
\usage{
Polypeptides_Carrier_Drug

Polypeptides_Enzyme_Drug

Polypeptide_Target_Drug

Polypeptides_Transporter_Drug
}
\description{
Descriptions of identified polypeptide targets, enzymes, carriers, or transporters.
}
\details{
Each target, enzyme, carrier and transporter elements may include one or more
polypeptide.
}
\keyword{datasets}
