% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{adjust_pretest}
\alias{adjust_pretest}
\title{Calculate pretest probability change over time}
\usage{
adjust_pretest(pre0, asympt, days = 14, mu = 1.63, sigma = 0.5)
}
\arguments{
\item{pre0}{Initial pretest probability (on day of exposure)}

\item{asympt}{The proportion of positive patients who would be expected not
to ever develop symptoms (true asymptomatic patients).}

\item{days}{Days since exposure for calculation range}

\item{mu}{The mean of a lognormal distribution that approximates the
incubation period for COVID-19. E.g. 1.63 (see reference).}

\item{sigma}{The standard deviation of a lognormal distribution that
approximates the incubation period for COVID-19. E.g. 0.5
(see reference).}
}
\value{
pretest probability by day (time series)
}
\description{
Calculates the pretest probability over time, assuming the individual does
not develop symptoms, by taking into account the distribution of incubation
periods (defined as the time from exposure to symptom onset).
}
\references{
See McAloon et al. \url{https://bmjopen.bmj.com/content/10/8/e039652/}
}
