% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{unit_probability}
\alias{unit_probability}
\title{Calculate a time series of unit-wide probability following exposure}
\usage{
unit_probability(test_day, pre0, sens, spec, asympt, days, mu, sigma, n)
}
\arguments{
\item{test_day}{Day of PCR test (days since exposure)}

\item{pre0}{Pre-test probability of person on day of exposure}

\item{sens}{A vector of sensitivities by day since exposure}

\item{spec}{The specificity of the PCR test}

\item{asympt}{The proportion of infected patients expected to remain
asymptomatic throughout the course of infection}

\item{days}{Days since exposure for calculation range}

\item{mu}{The mean of a lognormal distribution that approximates the
incubation period for COVID-19. E.g. 1.63 (see reference).}

\item{sigma}{The standard deviation of a lognormal distribution that
approximates the incubation period for COVID-19. E.g. 0.5
(see reference).}

\item{n}{Number of exposed individuals}
}
\value{
The probability of an event with the specified probability, after n
repetitions
}
\description{
To calculate the probability that any asymptomatic person has COVID-19,
this function treats each person/exposure as independent events and
calculates the probability time series using the individuals time series from
\code{individual_probability()}.
}
