% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CowbellAnalyzer.R
\name{summary.cowbell}
\alias{summary.cowbell}
\title{Generates the core information of the cowbell analysis.}
\usage{
\method{summary}{cowbell}(object, ...)
}
\arguments{
\item{object}{The resulting object of \code{\link{generateCowbell}}.}

\item{...}{Just for compatibility purposes.}
}
\value{
List with the mentioned values.
}
\description{
Generates a list that contains relevant information of the cowbell analysis. \code{concept} contains the formula and the minimal
and maximal values. \code{baseDefinition} contains the information for the cowbell. This is the minimal and the maximal value the
cowbell can reach and the position of the breaking point. \code{baseDefinitionReduced} only contains the minimal and the maximal value,
the breakpoint is not included in that model. \code{functionString} is a string version of the R function that generates the cowbell.
\code{functionStringReduced} is the string version without the breaking point. \code{fstatistic} contains the fstatistic information of the
cowbell model in contrast to the constant function. \code{fstatisticBreakpoint} describes the F-statistics of the full cowbell model against the version
without break point.
}
\details{
Implementation of the \code{\link{summary}} generic.
}
\examples{
# Run a simplified anaylsis with 10 iterations only (to save time.)
concept<-generateCowbellConcept(Fun ~ Fluency * Absorption, 1, 9, 1, 7, 1, 7)
data(allFun)
test<-generateCowbell(concept, allFun, 10)
summary(test)$functionString
}
