% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglikelihood.R
\name{loglikelihood}
\alias{loglikelihood}
\title{Determine the (quasi) Log Likelihood for a regression object.}
\usage{
loglikelihood(x, ...)
}
\arguments{
\item{x}{a regression fit object}

\item{...}{passed through to \code{\link[stats]{logLik}}}
}
\value{
the numeric value of the (quasi) log likelihood.
}
\description{
Return, via \code{\link[stats]{logLik}} or a custom S3 method, the (quasi)
log likelihood of a regression object.
}
\details{
This function is used by \code{cpr} and \code{cnr} to determine the
(quasi) log likelihood returned in the \code{cpr_cpr} and \code{cpr_cnr}
objects.

Generally this function defaults to \code{\link[stats]{logLik}}.  Therefore, if an S3
method for determining the (quasi) log likelihood exists in the workspace
everything should work.  If an S3 method does not exist you should define
one.

See \code{methods(loglikelihood)} for a list of the provided methods.  The
default method uses \code{\link[stats]{logLik}}.
}
\examples{

fit <- lm(mpg ~ wt, data = mtcars)
stats::logLik(fit)
cpr:::loglikelihood(fit)

}
\seealso{
\code{\link{cpr}} \code{\link{cnr}} \code{\link[stats]{logLik}}
}
