% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cpr_cnr.R
\name{plot.cpr_cnr}
\alias{plot.cpr_cnr}
\title{Control Net Reduction Plots}
\usage{
\method{plot}{cpr_cnr}(x, type = "rse", from = 1, to, ...)
}
\arguments{
\item{x}{a \code{cpr_cnr} object}

\item{type}{type of diagnostic plot.
\code{"loglik"} for the log likelihood by degrees of freedom,
\code{"rse"} for residual standard error by model index}

\item{from}{the first index of \code{x} to plot}

\item{to}{the last index of \code{x} to plot}

\item{...}{pass through}
}
\value{
a ggplot
}
\description{
A collection of function for the inspection and evaluation of the control
polygon reduction.
}
\examples{
initial_cn <- cn(log10(pdg) ~ btensor(list(day, age)
                        , df = list(10, 8)
                        , bknots = list(c(-1, 1), c(44, 53))
                        )
          , data = spdg)

cnr0 <- cnr(initial_cn)

plot(cnr0)

}
