% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cram_policy_value_estimator.R
\name{cram_policy_value_estimator}
\alias{cram_policy_value_estimator}
\title{Cram Policy: Estimator for Policy Value (Psi)}
\usage{
cram_policy_value_estimator(X, Y, D, pi, batch_indices, propensity = NULL)
}
\arguments{
\item{X}{A matrix or data frame of covariates for each sample.}

\item{Y}{A vector of outcomes for the n individuals.}

\item{D}{A vector of binary treatments for the n individuals.}

\item{pi}{A matrix of n rows and (nb_batch + 1) columns,
where n is the sample size and nb_batch is the number of batches,
containing the policy assignment for each individual for each policy.
The first column represents the baseline policy.}

\item{batch_indices}{A list where each element is a vector of indices corresponding to the individuals in each batch.}

\item{propensity}{Propensity score function}
}
\value{
The estimated policy value.
}
\description{
This function returns the cram estimator for the policy value (psi).
}
