# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Disable or enable parallelised computing
#'
#' By default, the package will use multithreading for many calculations if OpenMP is
#' available on the system. For multi-user systems this may not be desired, so parallel
#' execution can be disabled with this function.
#'
#' @param parallel_ Logical indicating whether to use parallel computation (TRUE) or disable it (FALSE)
#' @param cores_ Number of cores for parallel execution
#' @return None, called for effects
setParallelCRT <- function(parallel_, cores_ = 2L) {
    invisible(.Call(`_crctStepdown_setParallelCRT`, parallel_, cores_))
}

#' The quasi-score statistic for a generalised linear mixed model
#'
#' Generates the quasi-score statistic for a generalised linear mixed model
#'
#' @param resids A numeric vector of generalised residuals
#' @param tr A numeric vector of 1s (treatment group) and -1s (control group)
#' @param xb A numeric vector of fitted linear predictors
#' @param invS A matrix. If using the weighted statistic then it should be the inverse covariance matrix of the observations
#' @param family2 A string naming the link function
#' @param Z A matrix with columns indicating cluster membership
#' @param weight Logical value indicating whether to use the weighted statistic (TRUE) or the unweighted statistic (FALSE)
#' @return A scalar value with the value of the statistic
qscore_impl <- function(resids, tr, xb, invS, family2, Z, weight = TRUE) {
    .Call(`_crctStepdown_qscore_impl`, resids, tr, xb, invS, family2, Z, weight)
}

#' Generates realisations of the permutational test statistic distribution
#'
#' Generates realisations of the permutational test statistic distribution from a given matrix of permutations
#'
#' @param resids A numeric vector of generalised residuals
#' @param tr_mat A matrix. Each column is a new random treatment allocation with 1s (treatment group) and 0s (control group)
#' @param xb A numeric vector of fitted linear predictors
#' @param invS A matrix. If using the weighted statistic then it should be the inverse covariance matrix of the observations
#' @param family2 A string naming the link function
#' @param Z A matrix with columns indicating cluster membership
#' @param weight Logical value indicating whether to use the weighted statistic (TRUE) or the unweighted statistic (FALSE)
#' @param iter Integer. Number of permutation test iterations.
#' @param verbose Logical indicating whether to report detailed output
#' @return A numeric vector of quasi-score test statistics for each of the permutations
permutation_test_impl <- function(resids, tr_mat, xb, invS, family2, Z, weight, iter = 1000L, verbose = TRUE) {
    .Call(`_crctStepdown_permutation_test_impl`, resids, tr_mat, xb, invS, family2, Z, weight, iter, verbose)
}

#' Confidence interval search procedure
#'
#' Search for the bound of a confidence interval using permutation test statistics
#'
#' @param start Numeric value indicating the starting value for the search procedure
#' @param b Numeric value indicating the parameter estimate
#' @param n Integer indicating the sample size
#' @param nmodel Integer. The number of models
#' @param Xnull_ Numeric matrix. The covariate design matrix with the treatment variable removed
#' @param y Numeric vector of response variables
#' @param tr_ Numeric vector. The original random allocation (0s and 1s)
#' @param new_tr_mat A matrix. Each column is a new random treatment allocation with 1s (treatment group) and 0s (control group)
#' @param invS A matrix. If using the weighted statistic then it should be the inverse covariance matrix of the observations
#' @param family A \link{stats}[family] object
#' @param family2 A string naming the link function
#' @param Z Matrix. Random effects design matrix describing cluster membership
#' @param type String. Either "rw" for Romano-Wolf, "b" or "br" for bonferroni, "h" or "hr" for Holm, or "none"
#' @param nsteps Integer specifying the number of steps of the search procedure
#' @param weight Logical indicating whether to use the weighted (TRUE) or unweighted (FALSE) test statistic
#' @param alpha The function generates (1-alpha)*100% confidence intervals. Default is 0.05.
#' @param verbose Logical indicating whether to provide detailed output.
#' @return The estimated confidence interval bound
confint_search <- function(start, b, n, nmodel, Xnull_, y, tr_, new_tr_mat, invS, family, family2, Z, type, nsteps = 1000L, weight = TRUE, alpha = 0.05, verbose = TRUE) {
    .Call(`_crctStepdown_confint_search`, start, b, n, nmodel, Xnull_, y, tr_, new_tr_mat, invS, family, family2, Z, type, nsteps, weight, alpha, verbose)
}

#' A very basic linear model solver
#'
#' Returns the OLS paramter estimates and fitted values. Used internally for quick
#' fitting of null models.
#'
#' @param y_ A vector of outcome values
#' @param X_ The design matrix of fixed effects
#' @return A list with the parameter values and fitted values
simpleLM <- function(y_, X_) {
    .Call(`_crctStepdown_simpleLM`, y_, X_)
}

