% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IR_DV01.R
\name{IR_DV01}
\alias{IR_DV01}
\title{Calculate IR.DV01}
\usage{
IR_DV01(
  x,
  date.var = "date",
  currency.var = "currency",
  maturity.var = "maturity",
  tenor.var = "tenor",
  spread.var = "spread",
  coupon.var = "coupon",
  recovery.var = "recovery",
  notional.var = "notional",
  notional = 1e+07,
  recovery = 0.4
)
}
\arguments{
\item{x}{data frame, contains all the relevant columns.}

\item{date.var}{character, column in x containing date variable.}

\item{currency.var}{character, column in x containing currency.}

\item{maturity.var}{character, column in x containing maturity date.}

\item{tenor.var}{character, column in x containing tenors.}

\item{spread.var}{character, column in x containing spread in basis points.}

\item{coupon.var}{character, column in x containing coupon rates in basis 
points. It specifies the payment amount from the protection buyer to the 
seller on an annual basis.}

\item{recovery.var}{character, column in x containing recovery rates. ISDA
model standard recovery rate asscumption is 0.4.}

\item{notional.var}{character, column in x containing the amount of the 
underlying asset on which the payments are based.}

\item{notional}{numeric, the notional amount for all pricing if there isn't a
notional.var}

\item{recovery}{numeric, the recovery rate for all pricing if there isn't a 
recovery.var}
}
\value{
a vector containing the change in upfront when there is a 1/1e4 
  increase in interest rate, for each corresponding CDS contract.
}
\description{
\code{IR_DV01} calculate the amount of change in upfront when there is a
1/1e4 increase in interest rate for a data frame of CDS contracts.
}
\examples{
x <- data.frame(date = c(as.Date("2014-04-22"), as.Date("2014-04-22")),
                currency = c("USD", "EUR"),
                tenor = c(5, 5),
                spread = c(120, 110),
                coupon = c(100, 100),
                recovery = c(0.4, 0.4),
                notional = c(10000000, 10000000),
                stringsAsFactors = FALSE)
IR_DV01(x)
}
