% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{nz_murders_sf}
\alias{nz_murders_sf}
\title{Murders in New Zealand (2004 - 2019)}
\format{
An sf data frame with 967 observations and 12 variables:
\describe{
  \item{sex}{Sex of the victim (character).}
  \item{age}{Age of the victim (integer).}
  \item{date}{Date of the murder (character).}
  \item{year}{Year the murder occurred (integer).}
  \item{cause}{Cause of death (character).}
  \item{killer}{Name of the alleged killer (character).}
  \item{name}{Name of the victim (character).}
  \item{full_date}{Full date and time of the murder (POSIXct).}
  \item{month}{Month of the murder (ordered factor with 12 levels).}
  \item{cause_cat}{Category of the cause of death (character).}
  \item{region}{Region where the murder occurred (character).}
  \item{geometry}{Geographic coordinates (sf POINT) representing the location of the murder (list of 967).}
}
}
\source{
Recorded murder data for New Zealand (2004 - 2019).
}
\usage{
data(nz_murders_sf)
}
\description{
This dataset contains information about recorded murder cases in New Zealand between 2004 and 2019.
It includes details on the sex, age, and cause of death of the victims, as well as the identity of the
alleged killer, the date of the crime, and the region where the crime occurred. The dataset is in the
form of a simple features (sf) object, with geographic data represented as points.
}
\details{
The dataset name has been changed to 'nz_murders_sf' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
crimedatasets package and assists users in identifying its specific characteristics. The suffix
'_sf' indicates that the dataset is an sf object in R, used for storing and handling spatial data.
The original content has not been modified in any way.
}
