% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{vehiclethefts_tbl_df}
\alias{vehiclethefts_tbl_df}
\title{NYC Vehicle Thefts (2014-2017)}
\format{
A tibble with 35,746 rows and 9 variables:
\describe{
  \item{uid}{Unique identifier for each record (integer).}
  \item{date_single}{Single date of the incident (character).}
  \item{date_start}{Start date of the incident (character).}
  \item{date_end}{End date of the incident (character).}
  \item{longitude}{Longitude of the theft location (numeric).}
  \item{latitude}{Latitude of the theft location (numeric).}
  \item{location_type}{Type of location where the theft occurred (character).}
  \item{location_category}{Category of the location (character).}
  \item{census_block}{Census block of the theft location (character).}
}
}
\source{
Crime Open Database: Motor Vehicle Theft Records.
}
\usage{
data(vehiclethefts_tbl_df)
}
\description{
This dataset contains detailed records of motor vehicle thefts in New York City from 2014 to 2017.
The dataset includes spatial coordinates, timestamps, and additional contextual information about
each theft. It provides valuable insights into patterns and trends of vehicle thefts in NYC.
}
\details{
The dataset name has been changed to 'vehiclethefts_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
crimedatasets package and assists users in identifying its specific characteristics. The suffix 'tbl_df'
indicates that the dataset is stored as a tibble in R. The original content has not been modified in any way.
}
