\name{getofftargetdata}
\alias{getofftargetdata}
\title{Off Target Data Frame Creation}
\description{
Will provide a data frame with all information about the generated sgRNA returned by the sgRNA_design function.
}
\usage{
getofftargetdata(x)
}
\arguments{
  \item{x}{the data list generated by the sgRNA_design function
  }
}
\value{
A data frame containing all information on potential off-target sequences generated by the sgRNA_design function. Information includes the original sgRNA sequence, off-target sequence, chromosome, location, direction relative to the target sequence, number of mismatches, gene ID, gene name, type of DNA, and exon number.
}
\author{
Dylan Beeber
}
\examples{

## Quick example without off-target searching or annotation
## First generate data with the sgRNA_Design Function
testseq <- "GGCAGAGCTTCGTATGTCGGCGATTCATCTCAAGTAGAAGATCCTGGTGCAGTAGG"
usergenome <- "placeholder"
gtfname <- "placeholder"
alldata <- sgRNA_design(testseq, usergenome, gtfname, calloffs = FALSE)
## Then separate and format the off-target data with getofftargetdata()
final_data <- getofftargetdata(alldata)

\donttest{
## Longer example with off-target searching and annotation
## First generate data with the sgRNA_Design Function
requireNamespace("BSgenome.Scerevisiae.UCSC.sacCer3", quietly = TRUE)
testseq <- "GGCAGAGCTTCGTATGTCGGCGATTCATCTCAAGTAGAAGATCCTGGTGCAGTAGG"
usergenome <- BSgenome.Scerevisiae.UCSC.sacCer3::BSgenome.Scerevisiae.UCSC.sacCer3
gtfname <- "Saccharomyces_cerevisiae.R64-1-1.92.gtf.gz"
annotation_file <- system.file("example_data", gtfname, package = "crispRdesignR")
alldata <- sgRNA_design(testseq, usergenome, annotation_file)
## Then separate and format the sgRNA data with getofftargetdata()
final_data <- getofftargetdata(alldata)
}
}
