% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clattice.R
\name{hkl_to_reso}
\alias{hkl_to_reso}
\title{Calculates resolution, given the Miller indices}
\usage{
hkl_to_reso(h, k, l, a, b, c, aa, bb, cc)
}
\arguments{
\item{h}{An integer, A Miller index.}

\item{k}{An integer, A Miller index.}

\item{l}{An integer, A Miller index.}

\item{a}{A real number. One of the unit cell's side lengths, in angstroms.}

\item{b}{A real number. One of the unit cell's side lengths, in angstroms.}

\item{c}{A real number. One of the unit cell's side lengths, in angstroms.}

\item{aa}{A real number. One of the unit cell's angles, in degrees.}

\item{bb}{A real number. One of the unit cell's angles, in degrees.}

\item{cc}{A real number. One of the unit cell's angles, in degrees.}
}
\value{
A positive, real number. The resolution associated with (h,k,l), in angstroms.
}
\description{
Calculates resolution, given the Miller indices
}
\examples{
datadir <- system.file("extdata",package="cry")
fname <- file.path(datadir,"1dei_phases.mtz")
hdr <- readMTZHeader(fname,message=FALSE)
ucell <- hdr$CELL
reso1 <- hkl_to_reso(1,0,0,ucell[1],ucell[2],ucell[3],ucell[4],ucell[5],ucell[6])
print(reso1)  # Low resolution
reso2 <- hkl_to_reso(20,20,20,ucell[1],ucell[2],ucell[3],ucell[4],ucell[5],ucell[6])
reso2  # High resolution
}
