% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_orderbook_liquidity.R
\name{get_orderbook_liquidity}
\alias{get_orderbook_liquidity}
\title{Get liquidity sums in the order book of cryptocurrencies}
\usage{
get_orderbook_liquidity(pair, exchange = "kraken", api_key = NULL, allowance = FALSE)
}
\arguments{
\item{pair}{A character string containing a pair symbol, e.g. \emph{btcusd} (required argument). Run \code{get_pairs()} to find other available pairs.}

\item{exchange}{A character string containing the exchange. Default is \emph{kraken}. Run \code{get_exchanges()} to find other available exchanges.}

\item{api_key}{A character string containing the API key. See \url{https://docs.cryptowat.ch/rest-api/rate-limit} to learn how to create an account and how to generate an API key.}

\item{allowance}{A logical (default is \code{FALSE}). If \code{TRUE} the function returns a list which includes allowance information, i.e. cost of the request, remaining credits and your account name.}
}
\value{
A list containing liquidity sums at several basis point levels in the order book. If allowance is \code{TRUE}, \code{get_orderbook()} returns a list which additionally includes allowance information.
}
\description{
Get liquidity sums in the order book of cryptocurrencies using the REST API of cryptowat.ch. The route is \emph{orderbook/liquidity}. See \url{https://docs.cryptowat.ch/rest-api/markets/order-book} for further information.
}
\examples{
\dontrun{
# Get liquidity sums in the order book of Bitcoin in USD
liquidity <- get_orderbook_liquidity("btcusd")
}

}
\references{
See \url{https://docs.cryptowat.ch/rest-api} for further information.
}
\seealso{
\code{\link{get_markets}}, \code{\link{get_orderbook}}, \code{\link{get_exchanges}}, \code{\link{get_pairs}}
}
