% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tail_curry.R
\name{tail_curry}
\alias{\%-<\%}
\alias{tail_curry}
\title{Curry a function from the end}
\usage{
fun \%-<\% arg

tail_curry(fun, arg)
}
\arguments{
\item{fun}{A function to be curried from the end. Can be any function
(normal, already (tail_)curried, primitives).}

\item{arg}{The value that should be applied to the last argument.}
}
\value{
A function with the same arguments as \code{fun} except for the
last named argument, unless the only one is \code{...} in which case it will
be retained.
}
\description{
The \code{tail_curry} function and the \code{\%-<\%} operator performs
currying on a function by partially applying the last argument, returning a
function that accepts all but the last arguments of the former function. If
the last argument is \code{...} the curried argument will be interpreted as
the last named argument. If the only argument to the function is \code{...}
the curried argument will be interpreted as part of the ellipsis and the
ellipsis will be retained in the returned function. It is thus possible to
curry functions comtaining ellipis arguments to infinity (though not
adviced).
}
\note{
Multiple tail_currying does not result in multiple nested calls, so
while the first tail_currying adds a layer around the curried function,
potentially adding a very small performance hit, tail_currying multiple times
will not add to this effect.
}
\examples{
# Equivalent to tail_curry(`/`, 5)
divide_by_5 <- `/` \%-<\% 5
divide_by_5(10)

no_factors <- data.frame \%-<\% FALSE
no_factors(x = letters[1:5])

}
\seealso{
Other partials: \code{\link{curry}}, \code{\link{partial}}
}

