% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve.R
\name{curveopt}
\alias{curveopt}
\title{Optimise curve parameters}
\usage{
curveopt(
  x,
  y,
  type = "logistic",
  constant = c(TRUE, FALSE),
  reps = 3,
  sign = NULL,
  q = NULL,
  winit = NULL,
  yhat = NULL,
  wsel = c("select", "combine"),
  dummy = NULL,
  sameSign = c(TRUE, FALSE)
)
}
\arguments{
\item{x}{A matrix of explanatory variables. Excess reserve must be the first input.Additional regressor follow (optional).}

\item{y}{A vector of normalised interest rates.}

\item{type}{The type of the reserve demand curve. This can be any of \code{logistic}, \code{redLogistic}, \code{fixLogistic}, \code{doubleExp}, \code{exponential}, \code{fixExponential}, \code{arctan}, \code{linear}. See details in \code{\link{curve}}}

\item{constant}{A logical (\code{TRUE} or \code{FALSE}) whether to include a constant or not.}

\item{reps}{Number of repetitions for the particle swarm optimisation.}

\item{sign}{A vector of equal length to the number of additional regressors in \code{x} (excluding the constant (if used) and the excess reserves) of positive and negative values (any) that will be used to obtain signs to restrict the values of the estimated parameters. Use \code{NULL} for no restrictions.}

\item{q}{The desired quantile to optimise for. Use \code{NULL} to get the conditional expectation.}

\item{winit}{A vector of initial values for the optimisation. This will also carry over to sign restrictions if \code{sameSign==TRUE}.}

\item{yhat}{Useful when estimating quantiles. Supply here the predicted values for the conditional expectation to add restrictions for the quantiles to not cross the conditional expectation. Use \code{NULL} to not add any restrictions.}

\item{wsel}{Use the minimum error set of parameters (\code{select}) or the combination of the pool parameters using the heuristic in Kourentzes et al., (2019) (\code{combine}).}

\item{dummy}{Optional input to signify a regime change (vertical shifts in the curve). Must be a vector of equal length to the rows of \code{x}. If not needed use \code{NULL}.}

\item{sameSign}{Used if \code{winit != NULL} to take any sign restrictions from \code{winit}.}
}
\value{
Returns a list of
\itemize{
 \item \code{w} The optimal parameters
 \item \code{mse} The Mean Squared Error of the fitted curve.
}
}
\description{
Finds optimal curve parameters.
}
\examples{
\dontshow{
  rate <- head(ecb$rate,10)
  x <- ecb$x[1:10,1,drop=FALSE]
  curveopt(x,rate,reps=1,type="fixExponential")
}
\donttest{
  # Use ECB example data
  rate <- ecb$rate
  x <- ecb$x[,1,drop=FALSE]
  curveopt(x,rate)
}

}
\references{
\itemize{
 \item Chen, Z., Kourentzes, N., & Veyrune, R. (2023). \href{https://www.imf.org/en/Publications/WP/Issues/2023/09/01/Modeling-the-Reserve-Demand-to-Facilitate-Central-Bank-Operations-538754}{Modeling the Reserve Demand to Facilitate Central Bank Operations.} IMF Working Papers, 2023(179).
 \item Kourentzes, N., Barrow, D., & Petropoulos, F. (2019). Another look at forecast selection and combination: Evidence from forecast pooling. International Journal of Production Economics, 209, 226-235.
}
}
\seealso{
\code{\link{curve}}, and \code{\link{curvepred}}.
}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}
}
