% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvmTest.R
\name{cvmTest}
\alias{cvmTest}
\title{cvmTest}
\usage{
cvmTest(counts, p, pave = FALSE)
}
\arguments{
\item{counts}{vector containing the frequency of the counts in each group}

\item{p}{vector of probabilities for counts, often called p-hat}

\item{pave}{Logical. Set to be FALSE if the probabilities in groups are used; set to TRUE if the average of probabilities of groups j and j+1 are used}
}
\value{
A list with the components:

\item{Asq}{Anderson-Darling test statistic}

\item{Wsq}{Cramer-Von-Mises test statistic}

\item{Usq}{Watson's test statistic}

\item{Chisq}{Pearson's Chi-squared test statistic}

\item{Hj}{Estimated cumulative probability}
}
\description{
Calculate test statistics for grouped data's counts and probabilities
}
\details{
cvmTest is used by groupFit to calculate test statistics for the fitted distributions.
}
\examples{

#Choulakian, Lockhart and Stephens (1994)
counts <- c(10, 19, 18, 15, 11, 13, 7, 10, 13, 23, 15, 22)
phat <- rep(1/12, 12)

(stats1 <- cvmTest(counts, phat))

#Choulakian, Lockhart and Stephens (1994)
counts <- c(1 ,4 ,11 ,4 ,0)
phat <- c(0.05, 0.3, 0.3, 0.3, 0.05)

(stat2 <- cvmTest(counts, phat))

#Utilizing Benford's Law

#Setting pave to TRUE

#genomic data, Lesperance et al (2016)
genomic<- c(48, 14, 12, 6, 18, 5, 7, 8, 9)
phat<- log10(1+1/1:9)

(stat3 <- cvmTest(genomic, phat, pave = TRUE))

}
\seealso{
\code{\link{groupFit}}: Data fitting function
}
\author{
Shaun Zheng Sun and Dillon Duncan
}
