% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/malwarehash.R
\name{malware_hash}
\alias{malware_hash}
\title{Retrieves malware hash metadata from the Malware Hash Registry}
\usage{
malware_hash(hashes, timeout = getOption("timeout"))
}
\arguments{
\item{hashes}{vector of IPv4 address (character - dotted-decimal)}

\item{timeout}{numeric: the timeout (in seconds) to be used for this connection.
Beware that some OSes may treat very large values as zero: however the
POSIX standard requires values up to 31 days to be supported.}
}
\value{
data frame of BGP Origin ASN lookup results
  \itemize{
    \item \code{sha1_md5} - hash queried for
    \item \code{last_known_timestamp} - last known GMT timestamp associated with that hash
    \item \code{detection_pct} - detection percentage across a mix of AV packages
  }
  If a socket connection cannot be made (i.e. a network problem on your
  end or a service/network problem on their end), all columns will be
  \code{NA}.
}
\description{
The Malware Hash Registry (MHR) project is a look-up service similar to the
Team Cymru IP address to ASN mapping project. This project differs however,
in that you can query the service for a computed MD5 or SHA-1 hash of a file
and, if it is malware and the service knows about it, it returns the last
time it's seen it along with an approximate anti-virus detection percentage.
}
\note{
Attempting to enumerate the malware registry via the public service
      interface is not only impractical, it is also strictly prohibited.
      Contact Team Cymru if the public interface is insufficient for your
      needs and we may be able to come up with alternative arrangement. Also,
      A direct connection to TCP Port 43 (WHOIS) is required for most of these
      API functions to work properly.
}
\examples{
\dontrun{
malware_hash(c("1250ac278944a0737707cf40a0fbecd4b5a17c9d",
               "7697561ccbbdd1661c25c86762117613",
               "cbed16069043a0bf3c92fff9a99cccdc",
               "e6dc4f4d5061299bc5e76f5cd8d16610",
               "e1112134b6dcc8bed54e0e34d8ac272795e73d74"))
}
}
\seealso{
\url{http://www.team-cymru.org/IP-ASN-mapping.html}
}
