% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replicate_correlation.R
\name{replicate_correlation}
\alias{replicate_correlation}
\title{Measure replicate correlation of variables.}
\usage{
replicate_correlation(
  sample,
  variables,
  strata,
  replicates,
  replicate_by = NULL,
  split_by = NULL,
  cores = NULL
)
}
\arguments{
\item{sample}{tbl containing sample used to estimate parameters.}

\item{variables}{character vector specifying observation variables.}

\item{strata}{character vector specifying grouping variables for grouping prior to normalization.}

\item{replicates}{number of replicates.}

\item{replicate_by}{optional character string specifying column containing the replicate id.}

\item{split_by}{optional character string specifying column  by which to split the sample into batches; replicate correlations will be calculate per batch.}

\item{cores}{optional integer specifying number of CPU cores used for parallel computing using \code{doParallel}.}
}
\value{
data frame of variable quality measurements
}
\description{
`replicate_correlation` measures replicate correlation of variables.
}
\examples{
set.seed(123)
x1 <- rnorm(10)
x2 <- x1 + rnorm(10) / 100
y1 <- rnorm(10)
y2 <- y1 + rnorm(10) / 10
z1 <- rnorm(10)
z2 <- z1 + rnorm(10) / 1

batch <- rep(rep(1:2, each = 5), 2)

treatment <- rep(1:10, 2)

replicate_id <- rep(1:2, each = 10)

sample <-
  tibble::tibble(
    x = c(x1, x2), y = c(y1, y2), z = c(z1, z2),
    Metadata_treatment = treatment,
    Metadata_replicate_id = replicate_id,
    Metadata_batch = batch
  )

head(sample)

# `replicate_correlation`` returns the median, min, and max
# replicate correlation (across batches) per variable
replicate_correlation(
  sample = sample,
  variables = c("x", "y", "z"),
  strata = c("Metadata_treatment"),
  replicates = 2,
  split_by = "Metadata_batch",
  replicate_by = "Metadata_replicate_id",
  cores = 1
)
}
