% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evpi.R
\name{plot.evpi}
\alias{plot.evpi}
\title{Plot of Expected Value of Perfect Information (EVPI)}
\usage{
\method{plot}{evpi}(
  x,
  txtsize = 12,
  currency = "$",
  effect_units = "QALY",
  n_y_ticks = 8,
  n_x_ticks = 20,
  xbreaks = NULL,
  ybreaks = NULL,
  xlim = c(0, NA),
  ylim = NULL,
  ...
)
}
\arguments{
\item{x}{object of class \code{evpi}, produced by function
\code{\link{calc_evpi}}}

\item{txtsize}{base text size}

\item{currency}{string with currency used in the cost-effectiveness analysis (CEA).
Default: $, but it could be any currency symbol or word (e.g., £, €, peso)}

\item{effect_units}{units of effectiveness. Default: QALY}

\item{n_y_ticks}{number of y-axis ticks}

\item{n_x_ticks}{number of x-axis ticks}

\item{xbreaks}{vector of x-axis breaks.
will override \code{n_x_ticks} if provided.}

\item{ybreaks}{vector of y-axis breaks.
will override \code{n_y_ticks} if provided.}

\item{xlim}{vector of x-axis limits, or NULL, which sets limits automatically}

\item{ylim}{vector of y-axis limits, or NULL, which sets limits automatically}

\item{...}{further arguments to plot.
This is not used by \code{dampack} but required for generic consistency.}
}
\value{
A \code{ggplot2} plot with the EVPI
}
\description{
Plots the \code{evpi} object created by \code{\link{calc_evpi}}.
}
\seealso{
\code{\link{calc_evpi}}
}
\keyword{expected}
\keyword{information}
\keyword{of}
\keyword{perfect}
\keyword{value}
