% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateTheme_shinyDashboardThemeDIY.R
\name{shinyDashboardThemeDIY}
\alias{shinyDashboardThemeDIY}
\title{shinyDashboardThemeDIY}
\usage{
shinyDashboardThemeDIY(
  appFontFamily,
  appFontColor,
  logoBackColor,
  bodyBackColor,
  headerButtonBackColor,
  headerButtonIconColor,
  headerButtonBackColorHover,
  headerButtonIconColorHover,
  headerBackColor,
  headerBoxShadowColor,
  headerBoxShadowSize,
  sidebarBackColor,
  sidebarPadding,
  sidebarShadowRadius,
  sidebarShadowColor,
  sidebarMenuBackColor,
  sidebarMenuPadding,
  sidebarMenuBorderRadius,
  sidebarUserTextColor,
  sidebarSearchBackColor,
  sidebarSearchIconColor,
  sidebarSearchBorderColor,
  sidebarTabTextColor,
  sidebarTabTextSize,
  sidebarTabBorderStyle,
  sidebarTabBorderColor,
  sidebarTabBorderWidth,
  sidebarTabBackColorSelected,
  sidebarTabTextColorSelected,
  sidebarTabRadiusSelected,
  sidebarTabTextColorHover,
  sidebarTabBackColorHover,
  sidebarTabBorderStyleHover,
  sidebarTabBorderColorHover,
  sidebarTabBorderWidthHover,
  sidebarTabRadiusHover,
  boxBackColor,
  boxBorderRadius,
  boxShadowSize,
  boxShadowColor,
  boxTitleSize,
  boxDefaultColor,
  boxPrimaryColor,
  boxSuccessColor,
  boxWarningColor,
  boxDangerColor,
  tabBoxTabColor,
  tabBoxTabTextSize,
  tabBoxTabTextColor,
  tabBoxTabTextColorSelected,
  tabBoxBackColor,
  tabBoxHighlightColor,
  tabBoxBorderRadius,
  buttonBackColor,
  buttonTextColor,
  buttonBorderColor,
  buttonBorderRadius,
  buttonBackColorHover,
  buttonTextColorHover,
  buttonBorderColorHover,
  buttonHeight = "auto",
  buttonPadding = "6px 12px",
  textboxBackColor,
  textboxBorderColor,
  textboxBorderRadius,
  textboxBackColorSelect,
  textboxBorderColorSelect,
  textboxHeight = "auto",
  textboxPadding = "6px 12px",
  tableBackColor,
  tableBorderColor,
  tableBorderTopSize,
  tableBorderRowSize,
  primaryFontColor = "auto",
  successFontColor = "auto",
  warningFontColor = "auto",
  dangerFontColor = "auto",
  infoFontColor = "auto",
  boxInfoColor = "auto"
)
}
\arguments{
\item{appFontFamily}{String. Application font.}

\item{appFontColor}{String. Application font colour.}

\item{logoBackColor}{String. Logo background colour.}

\item{bodyBackColor}{String. Main page background colour.}

\item{headerButtonBackColor}{String. Sidebar toggle button background colour.}

\item{headerButtonIconColor}{String. Sidebar toggle button icon colour.}

\item{headerButtonBackColorHover}{String. Sidebar toggle button background colour: hovered.}

\item{headerButtonIconColorHover}{String. Sidebar toggle button icon colour: hovered.}

\item{headerBackColor}{String. Top header background colour.}

\item{headerBoxShadowColor}{String. Top header shadow colour.}

\item{headerBoxShadowSize}{String. Top header shadow size.}

\item{sidebarBackColor}{String. Sidebar background colour.}

\item{sidebarPadding}{Numeric. Sidebar inner padding.}

\item{sidebarShadowRadius}{String. Sidebar shadow radius.}

\item{sidebarShadowColor}{String. Sidebar shadow colour.}

\item{sidebarMenuBackColor}{String. Sidebar menu background colour.}

\item{sidebarMenuPadding}{Numeric. Sidebar menu inner padding.}

\item{sidebarMenuBorderRadius}{Numeric. Sidebar menu shape radius.}

\item{sidebarUserTextColor}{String. Sidebar userbox text colour.}

\item{sidebarSearchBackColor}{String. Sidebar searchbox background colour.}

\item{sidebarSearchIconColor}{String. Sidebar searchbox icon colour.}

\item{sidebarSearchBorderColor}{String. Sidebar searchbox border line colour.}

\item{sidebarTabTextColor}{String. Sidebar tab font colour.}

\item{sidebarTabTextSize}{Numeric. Sidebar tab font size.}

\item{sidebarTabBorderStyle}{String. Sidebar tab border line style.}

\item{sidebarTabBorderColor}{String. Sidebar tab border line colour.}

\item{sidebarTabBorderWidth}{Numeric. Sidebar tab border line width.}

\item{sidebarTabBackColorSelected}{String. Sidebar tab background colour: selected.}

\item{sidebarTabTextColorSelected}{String. Sidebar tab font colour: selected.}

\item{sidebarTabRadiusSelected}{String. Sidebar tab shape radius: selected.}

\item{sidebarTabTextColorHover}{String. Sidebar tab font colour: hovered.}

\item{sidebarTabBackColorHover}{String. Sidebar tab background colour: hovered.}

\item{sidebarTabBorderStyleHover}{String. Sidebar tab border line style: hovered.}

\item{sidebarTabBorderColorHover}{String. Sidebar tab border line colour: hovered.}

\item{sidebarTabBorderWidthHover}{Numeric. Sidebar tab border line width: hovered.}

\item{sidebarTabRadiusHover}{String. Sidebar tab shape radius: hovered.}

\item{boxBackColor}{String. Box background colour.}

\item{boxBorderRadius}{Numeric. Box shape radius.}

\item{boxShadowSize}{String. Box shadow size.}

\item{boxShadowColor}{String. Box shadow colour.}

\item{boxTitleSize}{Numeric. Box title font size.}

\item{boxDefaultColor}{String. Box default highlight colour.}

\item{boxPrimaryColor}{String. Box primary highlight colour.}

\item{boxSuccessColor}{String. Box success highlight colour.}

\item{boxWarningColor}{String. Box warning highlight colour.}

\item{boxDangerColor}{String. Box danger highlight colour.}

\item{tabBoxTabColor}{String. Tab box tab background colour.}

\item{tabBoxTabTextSize}{Numeric. Tab box tab font size.}

\item{tabBoxTabTextColor}{String. Tab box tab font colour.}

\item{tabBoxTabTextColorSelected}{String. Tab box tab font colour: selected.}

\item{tabBoxBackColor}{String. Tab box body background colour.}

\item{tabBoxHighlightColor}{String. Tab box highlight colour.}

\item{tabBoxBorderRadius}{Numeric. Tab box shape radius.}

\item{buttonBackColor}{String. Button background colour.}

\item{buttonTextColor}{String. Button font colour.}

\item{buttonBorderColor}{String. Button border line colour.}

\item{buttonBorderRadius}{Numeric. Button shape radius.}

\item{buttonBackColorHover}{String. Button background colour: hovered.}

\item{buttonTextColorHover}{String. Button font colour: hovered.}

\item{buttonBorderColorHover}{String. Button border line colour: hovered.}

\item{buttonHeight}{Numeric. Button shape height.}

\item{buttonPadding}{String. Button label padding. Defaults to "6px 12px".}

\item{textboxBackColor}{String. Textbox background colour.}

\item{textboxBorderColor}{String. Textbox border line colour.}

\item{textboxBorderRadius}{Numeric. Textbox shape radius.}

\item{textboxBackColorSelect}{String. Textbox background colour: selected.}

\item{textboxBorderColorSelect}{String. Textbox border line colour: selected.}

\item{textboxHeight}{Numeric. Textbox shape height.}

\item{textboxPadding}{String. Textbox text padding. Defaults to "6px 12px".}

\item{tableBackColor}{String. Table background colour.}

\item{tableBorderColor}{String. Table border line colour.}

\item{tableBorderTopSize}{Numeric. Table header line size.}

\item{tableBorderRowSize}{Numeric. Table row separator line size.}

\item{primaryFontColor}{String. Primary status highlight font colour.}

\item{successFontColor}{String. Success status highlight font colour.}

\item{warningFontColor}{String. Warning status highlight font colour.}

\item{dangerFontColor}{String. Danger status highlight font colour.}

\item{infoFontColor}{String. Info status highlight font colour.}

\item{boxInfoColor}{String. Box info highlight colour.}
}
\value{
CSS code. Theme for a shinydashboard application.
}
\description{
Creates a custom theme object for a shinydashboard application
}
\examples{
\donttest{
customTheme <- shinyDashboardThemeDIY(

  ### general
  appFontFamily = "Arial"
  ,appFontColor = "rgb(0,0,0)"
  ,primaryFontColor = "rgb(0,0,0)"
  ,infoFontColor = "rgb(0,0,0)"
  ,successFontColor = "rgb(0,0,0)"
  ,warningFontColor = "rgb(0,0,0)"
  ,dangerFontColor = "rgb(0,0,0)"
  ,bodyBackColor = "rgb(248,248,248)"

  ### header
  ,logoBackColor = "rgb(23,103,124)"

  ,headerButtonBackColor = "rgb(238,238,238)"
  ,headerButtonIconColor = "rgb(75,75,75)"
  ,headerButtonBackColorHover = "rgb(210,210,210)"
  ,headerButtonIconColorHover = "rgb(0,0,0)"

  ,headerBackColor = "rgb(238,238,238)"
  ,headerBoxShadowColor = "#aaaaaa"
  ,headerBoxShadowSize = "2px 2px 2px"

  ### sidebar
  ,sidebarBackColor = cssGradientThreeColors(
    direction = "down"
    ,colorStart = "rgb(20,97,117)"
    ,colorMiddle = "rgb(56,161,187)"
    ,colorEnd = "rgb(3,22,56)"
    ,colorStartPos = 0
    ,colorMiddlePos = 50
    ,colorEndPos = 100
  )
  ,sidebarPadding = 0

  ,sidebarMenuBackColor = "transparent"
  ,sidebarMenuPadding = 0
  ,sidebarMenuBorderRadius = 0

  ,sidebarShadowRadius = "3px 5px 5px"
  ,sidebarShadowColor = "#aaaaaa"

  ,sidebarUserTextColor = "rgb(255,255,255)"

  ,sidebarSearchBackColor = "rgb(55,72,80)"
  ,sidebarSearchIconColor = "rgb(153,153,153)"
  ,sidebarSearchBorderColor = "rgb(55,72,80)"

  ,sidebarTabTextColor = "rgb(255,255,255)"
  ,sidebarTabTextSize = 13
  ,sidebarTabBorderStyle = "none none solid none"
  ,sidebarTabBorderColor = "rgb(35,106,135)"
  ,sidebarTabBorderWidth = 1

  ,sidebarTabBackColorSelected = cssGradientThreeColors(
    direction = "right"
    ,colorStart = "rgba(44,222,235,1)"
    ,colorMiddle = "rgba(44,222,235,1)"
    ,colorEnd = "rgba(0,255,213,1)"
    ,colorStartPos = 0
    ,colorMiddlePos = 30
    ,colorEndPos = 100
  )
  ,sidebarTabTextColorSelected = "rgb(0,0,0)"
  ,sidebarTabRadiusSelected = "0px 20px 20px 0px"

  ,sidebarTabBackColorHover = cssGradientThreeColors(
    direction = "right"
    ,colorStart = "rgba(44,222,235,1)"
    ,colorMiddle = "rgba(44,222,235,1)"
    ,colorEnd = "rgba(0,255,213,1)"
    ,colorStartPos = 0
    ,colorMiddlePos = 30
    ,colorEndPos = 100
  )
  ,sidebarTabTextColorHover = "rgb(50,50,50)"
  ,sidebarTabBorderStyleHover = "none none solid none"
  ,sidebarTabBorderColorHover = "rgb(75,126,151)"
  ,sidebarTabBorderWidthHover = 1
  ,sidebarTabRadiusHover = "0px 20px 20px 0px"

  ### boxes
  ,boxBackColor = "rgb(255,255,255)"
  ,boxBorderRadius = 5
  ,boxShadowSize = "0px 1px 1px"
  ,boxShadowColor = "rgba(0,0,0,.1)"
  ,boxTitleSize = 16
  ,boxDefaultColor = "rgb(210,214,220)"
  ,boxPrimaryColor = "rgba(44,222,235,1)"
  ,boxInfoColor = "rgb(210,214,220)"
  ,boxSuccessColor = "rgba(0,255,213,1)"
  ,boxWarningColor = "rgb(244,156,104)"
  ,boxDangerColor = "rgb(255,88,55)"

  ,tabBoxTabColor = "rgb(255,255,255)"
  ,tabBoxTabTextSize = 14
  ,tabBoxTabTextColor = "rgb(0,0,0)"
  ,tabBoxTabTextColorSelected = "rgb(0,0,0)"
  ,tabBoxBackColor = "rgb(255,255,255)"
  ,tabBoxHighlightColor = "rgba(44,222,235,1)"
  ,tabBoxBorderRadius = 5

  ### inputs
  ,buttonBackColor = "rgb(245,245,245)"
  ,buttonTextColor = "rgb(0,0,0)"
  ,buttonBorderColor = "rgb(200,200,200)"
  ,buttonBorderRadius = 5

  ,buttonBackColorHover = "rgb(235,235,235)"
  ,buttonTextColorHover = "rgb(100,100,100)"
  ,buttonBorderColorHover = "rgb(200,200,200)"

  ,textboxBackColor = "rgb(255,255,255)"
  ,textboxBorderColor = "rgb(200,200,200)"
  ,textboxBorderRadius = 5
  ,textboxBackColorSelect = "rgb(245,245,245)"
  ,textboxBorderColorSelect = "rgb(200,200,200)"

  ### tables
  ,tableBackColor = "rgb(255,255,255)"
  ,tableBorderColor = "rgb(240,240,240)"
  ,tableBorderTopSize = 1
  ,tableBorderRowSize = 1

)
}
}
\seealso{
\code{\link{shinyDashboardThemes}, \link{shinyDashboardLogoDIY}, \link{cssGradientThreeColors}}
}
