% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grafico_notas_fecha.R
\name{grafico_notas_fecha}
\alias{grafico_notas_fecha}
\title{Grafico de notas por periodo (interactivo)}
\usage{
grafico_notas_fecha(
  datos,
  titulo,
  fecha_inicio = NULL,
  fecha_fin = NULL,
  agrupar_por = "day",
  tema = "light"
)
}
\arguments{
\item{datos}{Data frame con los datos procesados, que debe incluir la columna `fecha` en formato YYYY-MM-DD.}

\item{titulo}{Texto que aparecera en el titulo del grafico.}

\item{fecha_inicio}{Fecha de inicio para la construccion del grafico en formato YYYY-MM-DD (opcional).}

\item{fecha_fin}{Fecha de finalizacion para la construccion del grafico en formato YYYY-MM-DD (opcional).}

\item{agrupar_por}{Cadena de texto que especifica el periodo de agrupacion.
Valores validos son `"day"` (por defecto) o `"month"`.}

\item{tema}{Tema del grafico. Valores validos son `"light"` (por defecto) o `"dark"`.}
}
\value{
Un grafico plotly interactivo que muestra la cantidad de publicaciones por el periodo seleccionado.
}
\description{
Esta funcion genera un grafico interactivo que muestra la cantidad de publicaciones
agrupadas por dia o por mes, con opcion de tema dark o light.
}
\examples{
\dontrun{
# Ejemplo con tema dark, agrupando por mes
datos <- extraer_noticias_fecha("cambio climatico", "2024-01-01","2025-01-01", subir_a_bd = FALSE)
grafico_notas_fecha(datos, titulo = "Cambio Climatico (por mes)",
                    agrupar_por = "month", tema = "dark")

# Ejemplo con tema light, agrupando por dia
grafico_notas_fecha(datos, titulo = "Cambio Climatico (por dia)",
                    fecha_inicio = "2024-01-01", fecha_fin = "2024-03-31",
                    tema = "light")
}

}
