% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataquieR_resultset2.R
\name{prep_load_report_from_backend}
\alias{prep_load_report_from_backend}
\title{Load a report from a back-end}
\usage{
prep_load_report_from_backend(
  namespace = "objects",
  db_dir,
  storr_factory = prep_create_storr_factory(namespace = namespace, db_dir = db_dir)
)
}
\arguments{
\item{namespace}{the namespace to read the report's results from}

\item{db_dir}{\link{character} path to the directory for the back-end, if
a \code{storr_rds} or \code{storr_torr} is used.}

\item{storr_factory}{a function returning a \code{storr} object holding the report}
}
\value{
\link{dataquieR_resultset2} the report
}
\description{
Load a report from a back-end
}
\examples{
\dontrun{
r <- dataquieR::dq_report2("study_data", meta_data_v2 = "meta_data_v2",
                           dimensions = NULL)
storr_factory <- prep_create_storr_factory()
r_storr <- prep_set_backend(r, storr_factory)
r_restorr <- prep_set_backend(r_storr, NULL)
r_loaded <- prep_load_report_from_backend(storr_factory)
}
}
\seealso{
\code{\link[=prep_create_storr_factory]{prep_create_storr_factory()}}
}
