% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_study2meta.R
\name{prep_study2meta}
\alias{prep_study2meta}
\title{Guess a metadata data frame from study data.}
\usage{
prep_study2meta(
  study_data,
  level = c(VARATT_REQUIRE_LEVELS$REQUIRED, VARATT_REQUIRE_LEVELS$RECOMMENDED),
  cumulative = TRUE,
  convert_factors = FALSE,
  guess_missing_codes = getOption("dataquieR.guess_missing_codes",
    dataquieR.guess_missing_codes_default)
)
}
\arguments{
\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{level}{\link{enum} levels to provide (see also \link{VARATT_REQUIRE_LEVELS})}

\item{cumulative}{\link{logical} include attributes of all levels up to level}

\item{convert_factors}{\link{logical} convert factor columns to coded integers.
if selected, then also the study data will
be updated and returned.}

\item{guess_missing_codes}{\link{logical} try to guess missing codes from the data}
}
\value{
a meta_data data frame or a list with study data and metadata, if
\code{convert_factors == TRUE}.
}
\description{
Guess a minimum metadata data frame from study data. Minimum required variable
attributes are:
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{dataquieR:::util_get_var_att_names_of_level(VARATT_REQUIRE_LEVELS$REQUIRED)
#>            VAR_NAMES            DATA_TYPE   MISSING_LIST_TABLE 
#>          "VAR_NAMES"          "DATA_TYPE" "MISSING_LIST_TABLE"
}\if{html}{\out{</div>}}

The function also tries to detect missing codes.
}
\examples{
\dontrun{
dataquieR::prep_study2meta(Orange, convert_factors = FALSE)
}
}
