% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_acc_varcomp.R
\name{util_acc_varcomp}
\alias{util_acc_varcomp}
\title{Estimates variance components}
\usage{
util_acc_varcomp(
  resp_vars = NULL,
  label_col = NULL,
  study_data,
  item_level = "item_level",
  group_vars,
  co_vars = NULL,
  min_obs_in_subgroup = 30,
  min_subgroups = 5,
  meta_data = item_level,
  meta_data_v2
)
}
\arguments{
\item{resp_vars}{\link{variable list} the names of the continuous measurement
variables}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{item_level}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{group_vars}{\link{variable list} the names of the resp. observer, device or
reader variables}

\item{co_vars}{\link{variable list} a vector of covariables, e.g. age and sex for
adjustment}

\item{min_obs_in_subgroup}{\link{integer} from=0. optional argument if a
"group_var" is used. This argument
specifies the minimum no. of observations
that is required to include a subgroup
(level) of the "group_var" in the analysis.
Subgroups with fewer observations are
excluded. The default is 30.}

\item{min_subgroups}{\link{integer} from=0. optional argument if a "group_var" is
used. This argument specifies the
minimum no. of subgroups (levels)
included "group_var". If the variable
defined in "group_var" has fewer
subgroups it is not used for analysis.
The default is 5.}

\item{meta_data}{\link{data.frame} old name for \code{item_level}}

\item{meta_data_v2}{\link{character} path to workbook like metadata file, see
\code{\link{prep_load_workbook_like_file}} for details.
\strong{ALL LOADED DATAFRAMES WILL BE PURGED},
using \code{\link{prep_purge_data_frame_cache}},
if you specify \code{meta_data_v2}.}
}
\value{
a list with:
\itemize{
\item \code{SummaryTable}: data frame with ICCs per \code{rvs}
\item \code{SummaryData}: data frame with ICCs per \code{rvs}
\item \code{ScalarValue_max_icc}: maximum variance contribution value by group_vars
\item \code{ScalarValue_argmax_icc}: variable with maximum variance contribution by
group_vars
}
}
\description{
Variance based models and intraclass correlations (ICC) are approaches to
examine the impact of so-called process variables on the measurements. This
implementation is model-based.

\strong{NB:} The term ICC is frequently used to describe the agreement between
different observers, examiners or even devices. In respective settings a good
agreement is pursued. ICC-values can vary between \verb{[-1;1]} and an ICC close
to 1 is desired (Koo and Li 2016, Müller and Büttner 1994).

However, in multi-level analysis the ICC is interpreted differently. Please
see Snijders et al. (Sniders and Bosker 1999). In this context the proportion
of variance explained by respective group levels indicate an influence of (at
least one) level of the respective group_vars. An ICC close to 0 is desired.
}
\section{ALGORITHM OF THIS IMPLEMENTATION:}{
\itemize{
\item This implementation is yet restricted to data of type float.
\item Missing codes are removed from resp_vars (if defined in the metadata)
\item Deviations from limits, as defined in the metadata, are removed
\item A linear mixed-effects model is estimated for resp_vars using co_vars and
group_vars for adjustment.
\item An output data frame is generated for group_vars indicating the ICC.
}
}

\seealso{
\href{https://dataquality.qihs.uni-greifswald.de/VIN_acc_impl_varcomp.html}{Online Documentation}
}
\keyword{internal}
