% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_no_value_labels.R
\name{util_no_value_labels}
\alias{util_no_value_labels}
\title{Select really \link{numeric} variables}
\usage{
util_no_value_labels(resp_vars, meta_data, label_col, warn = TRUE, stop = TRUE)
}
\arguments{
\item{resp_vars}{\link{variable list} len=1-2. the name of the continuous
measurement variable}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{warn}{\link{logical} warn about removed variable names}

\item{stop}{\link{logical} stop on no matching \code{resp_var}}
}
\value{
\link{character} vector of matching \code{resp_vars}.
}
\description{
Reduce \code{resp_vars} to those, which are either \code{float} or \code{integer} without
\link{VALUE_LABELS}, i.e. likely \link{numeric} but not a \link{factor}
}
\seealso{
Other metadata_management: 
\code{\link{util_dist_selection}()},
\code{\link{util_find_free_missing_code}()},
\code{\link{util_find_var_by_meta}()},
\code{\link{util_get_var_att_names_of_level}()},
\code{\link{util_get_vars_in_segment}()},
\code{\link{util_looks_like_missing}()},
\code{\link{util_validate_known_meta}()},
\code{\link{util_validate_missing_lists}()}
}
\concept{metadata_management}
\keyword{internal}
