% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C3FURV.R
\name{duplicate_dates}
\alias{duplicate_dates}
\title{Duplicate dates test}
\usage{
duplicate_dates(dailydata, meta = NULL, outpath)
}
\arguments{
\item{dailydata}{A character string giving the path of the input file,
or a 5-column matrix with following columns: variable code, year, month,
day, and the daily value.}

\item{meta}{A character vector with 6 elements: station ID, latitude, longitude,
altitude, variable code, units. If \code{dailydata} is a path, \code{meta} is
ignored.}

\item{outpath}{Character string giving the path for the QC results.}
}
\description{
Flag dates that appear more than once in daily data.
}
\details{
The input file must follow the Copernicus Station Exchange Format (SEF).
}
\examples{
duplicate_dates(Rosario$Tx, Meta$Tx, outpath = tempdir())

}
\author{
Alba Gilabert, Yuri Brugnara
}
