% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comex.R
\name{load_br_trade}
\alias{load_br_trade}
\title{Comex - Brazilian external trade}
\usage{
load_br_trade(dataset, raw_data = FALSE, time_period, language = "eng")
}
\arguments{
\item{dataset}{A dataset name ("comex_export_mun", "comex_import_mun", "comex_export_prod" or "comex_import_prod").}

\item{raw_data}{A \code{boolean} setting the return of raw (\code{TRUE}) or processed (\code{FALSE}) data.}

\item{time_period}{A \code{numeric} indicating for which years the data will be loaded, in the format YYYY. Can be any vector of numbers, such as 2010:2012.}

\item{language}{A \code{string} that indicates in which language the data will be returned. Portuguese ("pt") and English ("eng") are supported.}
}
\value{
A \code{tibble}.
}
\description{
Loads data on all products imported to or exported from Brazil.
}
\examples{
\dontrun{
# download treated (raw_data = FALSE) exports data by municipality (dataset = "comex_export_mun")
# from 2020 to 2021 (time_period = 2020:2021)
data <- load_br_trade(
  dataset = "comex_export_mun",
  raw_data = FALSE,
  time_period = 2020:2021
)
# download treated(raw_data = FALSE) imports data by municipality (dataset = "comex_import_mun")
# from 2020 to 2021 (time_period = 2020:2021)
data <- load_br_trade(
  dataset = "comex_import_mun",
  raw_data = FALSE,
  time_period = 2020:2021
)
}

}
