% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population.R
\name{load_population}
\alias{load_population}
\title{Population}
\usage{
load_population(
  dataset = "population",
  raw_data = FALSE,
  geo_level,
  time_period,
  language = "eng"
)
}
\arguments{
\item{dataset}{A dataset name ("population").}

\item{raw_data}{A \code{boolean} setting the return of raw (\code{TRUE}) or processed (\code{FALSE}) data.}

\item{geo_level}{A \code{string} that defines the geographic level of the data. Can be one of "country", "state" or "municipality".}

\item{time_period}{A \code{numeric} indicating for which years the data will be loaded, in the format YYYY. Can be any vector of numbers, such as 2010:2012.}

\item{language}{A \code{string} that indicates in which language the data will be returned. Portuguese ("pt") and English ("eng") are supported.}
}
\value{
A \code{tibble}.
}
\description{
Loads information on (estimated) population
}
\examples{
\dontrun{
# Download raw data (raw_data = TRUE) at the country level
# from 2008 to 2010 (time_period = 2008:2010).
data <- load_population(
  raw_data = TRUE,
  geo_level = "country",
  time_period = 2008:2010
)

# Download treted data (raw_data = FALSE) by state (geo_level = "state")
# from 2008 to 2010 (time_period = 2008:2010) in portuguese (language = "pt").
data <- load_population(
  raw_data = FALSE,
  geo_level = "state",
  time_period = 2008:2010,
  language = "pt"
)
}

}
