% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daymet_grid_agg.r
\name{daymet_grid_agg}
\alias{daymet_grid_agg}
\title{Aggregate daily Daymet data}
\usage{
daymet_grid_agg(
  file,
  int = "seasonal",
  fun = "mean",
  internal = FALSE,
  path = tempdir()
)
}
\arguments{
\item{file}{The name of the file to be processed. Use daily gridded
Daymet data.}

\item{int}{Interval to aggregate by. Options are "monthly", 
"seasonal" or "annual". Seasons are defined as the astronomical seasons
between solstices and equinoxes (default = "seasonal")}

\item{fun}{Function to be used to aggregate data. Genertic R 
functions can be used. "mean" and "sum" are suggested. na.rm 
= TRUE by default. (default = "mean")}

\item{internal}{logical If FALSE, write the output to a tif 
file using the Daymet file format protocol.}

\item{path}{path to a directory where output files should be written.
Used only if internal = FALSE (default = tempdir())}
}
\value{
aggregated daily Daymet data as a tiff file written
to disk or a raster stack when data is returned to the workspace.
}
\description{
Aggregates daily Daymet data by time interval to create 
convenient seasonal datasets for data exploration or modelling.
}
\examples{

 \dontrun{
 # This code calculates the average minimum temperature by 
 # season for a subset region.
 
 # download default ncss tiled subset for 1980
 # (daily tmin values only), works on tiles as well
 download_daymet_ncss()
     
 # Finally, run the function
 daymet_grid_agg(
  file = file.path(tempdir(),"/tmin_daily_1980_ncss.nc"),
  int = "seasonal",
  fun = "mean"
 )
 }
}
