% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcov2d.R
\name{dcov2d}
\alias{dcov2d}
\alias{dcor2d}
\title{Fast distance covariance for two bivariate variables}
\usage{
dcov2d(x, y, type = c("V", "U"))

dcor2d(x, y, type = c("V", "U"))
}
\arguments{
\item{x}{the vector of x}

\item{y}{the vector of y}

\item{type}{"V" or "U", for V- or U-statistics of distance covariance or
correlation. The default value is "V".}
}
\description{
This method implements the fast algorithm proposed by \cite{Huo and Székely}. The
result of \code{dcov2d} and \code{dcor2d} is same with the result of
\code{energy::dcov2d} and \code{energy::dcor2d}
}
\examples{
x = rnorm(200)
y = rnorm(200)
dcov2d(x,y)
dcor2d(x,y)
}
\references{
Székely, G. J., Rizzo, M. L., & Bakirov, N. K. (2007). Measuring and testing dependence by correlation of distances. The annals of statistics, 35(6), 2769-2794.

Székely, G. J., & Rizzo, M. L. (2013). The distance correlation t-test of independence in high dimension. Journal of Multivariate Analysis, 117, 193-213.

Huo, X., & Székely, G. J. (2016). Fast computing for distance covariance. Technometrics, 58(4), 435-447.
}
