% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm.test.R
\name{dcor.test}
\alias{dcor.test}
\alias{pdcor.test}
\title{Permutation test of distance correlation and partial distance correlation}
\usage{
dcor.test(x, y, R = 500, type = c("V", "U"))

pdcor.test(x, y, z, R = 500, type = c("U", "V"))
}
\arguments{
\item{x}{the data of x}

\item{y}{the data of y}

\item{R}{the number of replicates}

\item{type}{"U" or "V"}

\item{z}{the data of controlling variables. Given z, pdcor between x and y is
calculated.}
}
\description{
Simple independence test based on data permutation using distance correlation
and partial distance correlation.
}
\examples{
n = 200
z = rnorm(n)
x = rnorm(n)*z
y = rnorm(n)*z
res1 = dcor.test(x,y,R=500)
res2 = pdcor.test(x,y,z,R=500)

}
