% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcDerivatives.R
\name{calcDerivatives}
\alias{calcDerivatives}
\title{Calculating the Derivatives}
\usage{
calcDerivatives(data, column, groupby, time = NA, order = 2, window = 5)
}
\arguments{
\item{data}{a data frame.}

\item{column}{names of variables in the long format that correspond to multiple variables in the wide format.}

\item{groupby}{Character vector. Only used if the data is in a data.frame.}

\item{time}{A variable name in the data frame containing sampling time information.}

\item{order}{integer scalar.}

\item{window}{integer scalar.Must be an odd number}
}
\value{
a data frame contains derivatives.
}
\description{
Calculating the Derivatives
}
\details{
examples
\preformatted{
#eg1.
derivatives1 <- calcDerivatives(data=example3,column='expected',groupby='year',order=2,window=5,interval=1)
#eg2.
derivatives2 <- calcDerivatives(data=example3,column=c('expected','current'),groupby='year',time='myTime',order=2,window=5,interval=1)
#eg3.
derivativese3 <- calcDerivatives(data=example3,column=c('expected','current'),groupby='year',order=2,window=5,interval=1)

}
}
