% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.deeptrafo}
\alias{plot.deeptrafo}
\title{Plot method for deep conditional transformation models}
\usage{
\method{plot}{deeptrafo}(
  x,
  which = NULL,
  type = c("smooth", "trafo", "pdf", "cdf"),
  newdata = NULL,
  which_param = c("shifting", "interacting"),
  only_data = FALSE,
  K = 40,
  q = NULL,
  ...
)
}
\arguments{
\item{x}{Object of class \code{"deeptrafo"}.}

\item{which}{Which effect to plot, default selects all smooth effects in the
shift term.}

\item{type}{Character; One of "smooth", "trafo", "pdf", or "cdf".}

\item{newdata}{Optional new data (\code{list} or \code{data.frame}) to
evaluate predictions at. If the response is missing, plots are generated
on a grid of length \code{K}}

\item{which_param}{Character; either \code{"interacting"} or \code{"shifting"}.}

\item{only_data}{Logical, if \code{TRUE}, only the data for plotting is returned.}

\item{K}{Integer; If \code{type == "smooth"} the length of an equidistant
grid at which a two-dimensional function is evaluated for plotting.
Otherwise, length of the grid to evaluate predictions at,
see \code{newdata}.}

\item{q}{Vector of response values to compute predictions at, see \code{newdata}}

\item{...}{Further arguments, passed to fit, plot or predict function}
}
\description{
Plot method for deep conditional transformation models
}
