% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daily.data.R
\name{daily.data}
\alias{daily.data}
\title{Calculation of daily statistics for dendrometer data}
\usage{
daily.data(df, TreeNum)
}
\arguments{
\item{df}{dataframe with first column containing date and time in the format \code{yyyy-mm-dd HH:MM:SS} and the dendrometer data in following columns.}

\item{TreeNum}{numerical value indicating the tree to be analysed. E.g. '1' refers to the first dendrometer data column in \emph{df}.}
}
\value{
A dataframe with the daily statistics of the dendrometer data that contains:
\tabular{llll}{
\strong{Columns}\tab\tab   \strong{Description}\cr
\code{DATE}\tab\tab    The day of year in "yyyy-mm-dd".\cr
\code{Min}\tab\tab    The minimum value record for the corresponding day.\cr
\code{Time_min}\tab\tab    The time when minimum value recorded for the corresponding day.\cr
\code{Max}\tab\tab    The maximum value record for the corresponding day.\cr
\code{Time_max}\tab\tab    The time when maximum value recorded for the corresponding day.\cr
\code{mean}\tab\tab    The daily average value of the dendrometer reading.\cr
\code{median}\tab\tab    The daily median value of the dendrometer reading.\cr
\code{amplitude}\tab\tab   The difference between daily maximum and daily minimum.\cr
\code{Remarks}\tab\tab   "*" if Time_max > Time_min otherwise "".\cr
}
}
\description{
This function calculates various statistics of dendrometer data on a daily basis. The daily statistics includes the daily maximum and minimum with their corresponding times and daily amplitude (difference between daily maximum and minimum). See King et al. (2013) for details.
}
\examples{
\donttest{library(dendRoAnalyst)
data(nepa17)
daily_stats<-daily.data(df=nepa17, TreeNum=1)
head(daily_stats,10)}

}
\references{
King G, Fonti P, Nievergelt D, Büntgen U, Frank D (2013) Climatic drivers of hourly to yearly tree radius variations along a 6°C natural warming gradient. Agricultural and Forest Meteorology 168:36–46. \doi{10.1016/j.agrformet.2012.08.002}
}
