% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packdepcoeff.R
\name{zetac}
\alias{zetac}
\title{Zeta dependence coefficient}
\usage{
zetac(x,y,method="Spearman",methodF=1,parH=0.5,parp=1.5)
}
\arguments{
\item{x, y}{data vectors of the two variables whose dependence is analysed.}

\item{method}{list of names of the coefficients: "Spearman" stands for the
Spearman coefficient, "footrule" means Spearman's footrule, "power" stands
for the power function coefficient, "Huber" means the Huber function
coefficient. If "all" is assigned to method then all methods are used.}

\item{methodF}{value 1,2 or 3 refers to several methods for computation of
the distribution function values, 1 is the default value.}

\item{parH}{parameter of the Huber function (default 0.5). Valid values for
parH are between 0 and 1.}

\item{parp}{parameter of the power function (default 1.5). The parameter has
to be positive.}
}
\value{
zeta dependence coefficient of two random variables. This coefficient
is bounded by 1. The higher the value the stronger is the dependence.
}
\description{
zetac is a function to evaluate the zeta dependence coefficient (one interval)
of two random variables x and y which is based on the copula. Four specific coefficients
are available: the Spearman coefficient, Spearman's footrule, the power coefficient
and the Huber function coefficient.
}
\details{
Let \eqn{X_{1},\ldots ,X_{n}} be the sample of the \eqn{X} variable. Formulas
for the estimators of values \eqn{F(X_{i})} of the distribution function:
  methodF = 1 \eqn{\rightarrow \hat{F}(X_{i})=\frac{1}{n}\textrm{rank}(X_{i})}
  methodF = 2 \eqn{\rightarrow \hat{F}^{1}(X_{i})=\frac{1}{n+1}\textrm{rank}(X_{i})}
  methodF = 3 \eqn{\rightarrow \hat{F}^{2}(X_{i})=\frac{1}{\sqrt{n^{2}-1}}\textrm{rank}(X_{i})}
The values of the distribution function of \eqn{Y} are treated analogously.
}
\examples{
library(MASS)
data<- gilgais
zetac(data[,1],data[,2])
}
\references{
Eckhard Liebscher (2014). Copula-based dependence measures. Dependence Modeling 2 (2014), 49-64
}
