% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFunctions.R
\name{w.ggscatterstats}
\alias{w.ggscatterstats}
\title{Wrapper for ggstatsplot::ggscatterstats with optional p-value annotation}
\usage{
w.ggscatterstats(data, parameter, groupby, pval.display = FALSE, ldat, ...)
}
\arguments{
\item{data}{A data frame with the data to be plotted.}

\item{parameter}{Character. Name of the column in \code{data} to the values to be plotted.}

\item{groupby}{Character. Name of the grouping (categorical) variable in \code{data}.}

\item{pval.display}{Logical. If \code{TRUE} and there are exactly two groups in \code{groupby}, a p-value annotation is added.}

\item{ldat}{A data frame containing the p-value(s) to annotate on the plot. Expected columns: `"p value"` and/or `"adjusted p value"`.}

\item{...}{Additional arguments passed to \code{\link[ggstatsplot]{ggscatterstats}}.}
}
\value{
A \code{ggplot} object.
}
\description{
This function creates a `ggscatterstats` plot from `ggstatsplot`, and optionally adds a p-value annotation based on values in `ldat`.
It can also format the y-axis as dates.
}
\details{
If \code{groupby} is not \code{NULL} and there are exactly two levels in the grouping variable, and \code{pval.display = TRUE}, a p-value from \code{ldat} is added between the two groups using \code{geom_signif}. If \code{"adjusted p value"} is present in \code{ldat}, it is used; otherwise, \code{"p value"} is used. If \code{wasDate} is \code{TRUE}, the y-axis labels are formatted as dates.
}
\examples{
## plot
p <- w.ggscatterstats(mtcars, parameter = "cyl", groupby = "carb",
                      bf.message = FALSE,)
if (FALSE) print(p)

## plot with p value annotation
pval <- cor.test(~ cyl + carb, data = mtcars, method = "kendall")$p.value
pval <- descutils::prettyPvalues(pval, digits = 3, orgbold = FALSE, lhs = "p")
ldat <- data.frame(`p value` = pval, check.names = FALSE)
p <- w.ggscatterstats(mtcars, parameter = "cyl", groupby = "carb", pval.display = TRUE, ldat = ldat,
                      bf.message = FALSE,)
if (FALSE) print(p)
}
\author{
Fabian Kück
}
