##' round and paste lower and upper (confidence) interval limits
##'
##' Given 0.56 and 1.22998 this will return [0.56; 1.23].
##'
##' @param conf.low numeric vector.  lower limits of the (confidence) interval
##' @param conf.high numeric vector of the same length of \code{conf.low}.  upper limits of the (confidence) interval.
##' @param digits numeric. number of digits to round the limits to
##' @return character of the form "[conf.low; conf.high]"
##' @author Dr. Andreas Leha
##' @export
##' @examples
##' prettyCI(0.56, 1.22998)
prettyCI <- function(conf.low, conf.high, digits = 2)
{
  if(length(conf.low)!=length(conf.high))
    stop("conf.low and conf.high do not have the same length")
  
  res <- c()
  for(i in 1:length(conf.low))
    res <- c(res, paste0("[",
                  descutils::prettyNumbers(conf.low[i],  digits = digits),
                  "; ",
                  descutils::prettyNumbers(conf.high[i], digits = digits),
                  "]"))
  return(res)
}
