% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crsize.R
\name{crsize}
\alias{crsize}
\title{Sample size determination for crossover study design}
\usage{
crsize(type, delta, m, k, mur, mut, sigbr, sigbt, rho, sigwr, sigwt,
       alpha, beta, r1, r2)
}
\arguments{
\item{type}{The three different types of tests are (1) test for equality, (2) test for non-inferiority/
superiority, (3) test for equivalence i.e. type = c("equal", "noninf.sup", "equiv")}

\item{delta}{Non-inferiority/Superiority margin}

\item{m}{Number of responses observed from each subject in each sequence
under a fixed treatment}

\item{k}{Ratio of the sample sizes of the two sequences}

\item{mur}{Mean value of reference therapy}

\item{mut}{Mean value of test therapy}

\item{sigbr}{Between standard deviation due to the effect of reference therapy}

\item{sigbt}{Between standard deviation due to the effect of test therapy}

\item{rho}{Correlation between reference and test therapy}

\item{sigwr}{Within standard deviation due to the effect of reference therapy}

\item{sigwt}{Within standard deviation due to the effect of test therapy}

\item{alpha}{Level of significance}

\item{beta}{The probability of type-II error}

\item{r1}{Proportion of factor-1}

\item{r2}{Proportion of factor-2}
}
\value{
crsize returns the required sample sizes for each sequence and their factors
in a 2x2 contingency table.
}
\description{
Determination of sample sizes for two factors of each group using one of the tests for
equality, non-inferiority/superiority or equivalence
}
\details{
Consider a 2x2m replicated crossover design for comparing mean responses of a test drug and a reference
drug. Under both treatments the design consists of two sequences with m subjects each.
}
\examples{

# (a) Test for equality:

# This is a crossover design. The type = "equal" tests the equality of mean responses of
# a test drug (mut = 9) and a reference drug (mur = 8.5) and the number of responses are
# m = 4 observed from  each subject in each  sequence. k = 1 indicates the  ratio of the
# sample sizes of the two sequences are equal. The between standard deviation due to the
# effect of reference therapy is sigbr = 1.5 and that of test therapy is 1.5. The corre-
# lation between reference and test  therapy is rho = 0.7. The within standard deviation
# due to the effect of reference therapy is sigwr = 1 as well as test therapy is sigwt =
# 1. The alpha = 0.05 is level of significance and the probability of type - II error is
# beta = 0.10. The proportion  of factor - 1 and factor - 2 are taken to be r1 = 0.5 and
# r2 = 0.5 respectively.


crsize(type= "equal", delta = 0.4, m = 4, k = 1, mur = 8.5, mut = 9, sigbr = 1.5,
       sigbt = 1.5, rho = 0.7, sigwr = 1, sigwt = 1, alpha = 0.05, beta = 0.10,
       r1 = 0.5, r2 = 0.5)


# (b) Test for non-inferiority/superiority:

# This is a crossover design. The type = "noninf.sup", tests  whether the  difference of
# mean responses of a test drug (mut = 9) and a reference drug (mur = 8.5) being greater
# than or equal to  the marginal value delta = 0.4. The  number of  responses are m = 4,
# observed from each subject in each sequence. The value of k = 1 indicates the ratio of
# the sample sizes of the two sequences are equal. The between standard deviation due to
# the effect of  reference  therapy is sigbr = 1.5 and that of  test therapy is 1.5. The
# correlation between reference and test therapy is rho = 0.7. The within standard devi-
# ation due to  the effect of reference therapy is sigwr = 1, as well as test therapy is
# sigwt = 1. A alpha = 0.05 is the level of significance and  the probability of type-II
# error is beta = 0.10. The proportion of factor-1 (r1) and factor-2 (r2) both are taken
# to be 0.5.


crsize(type = "noninf.sup", delta = 0.4, m = 4, k = 1, mur = 8.5, mut = 9, sigbr = 1.5,
       sigbt = 1.5, rho = 0.7, sigwr = 1, sigwt = 1, alpha = 0.05, beta = 0.10,
       r1 = 0.5, r2 = 0.5)



#(c) Test for equivalence:

# This is a crossover design. The type = "equiv" tests whether the absolute value of the
# difference of mean responses of a test drug (mut = 9) and a reference drug (mur = 8.5)
# being  less than or equal to  the marginal value delta = 0.6. The number  of responses
# are m = 4 observed from each subject in each sequence. k = 1, indicates that the ratio
# of the sample sizes of the two sequences are equal. The between standard deviation due
# to the effect of reference therapy is sigbr = 1.5 and that of test therapy is 1.5. The
# correlation between reference and test therapy is rho = 0.7. The within standard devi-
# ation due to  the effect of reference therapy is sigwr = 1 as well as  test therapy is
# sigwt = 1. alpha = 0.05 is  the level of significance and the probability of type - II
# error is beta = 0.10. The proportion of factor-1 (r1) and factor-2 (r2) both are taken
# to be 0.5.


crsize(type = "equiv", delta = 0.6, m = 4, k = 1, mur = 8.5, mut = 9, sigbr = 1.5,
       sigbt = 1.5,rho = 0.7, sigwr = 1, sigwt = 1, alpha = 0.05, beta = 0.10,
       r1 = 0.5, r2 = 0.5)

}
\seealso{
ABdesign crt.match crt.unmatch phsize precsize
}
\author{
Atanu Bhattacharjee, Rajashree Dey ,Soutik Halder and Akash Pawar
}
