% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EPS.value.R
\name{EPS.value}
\alias{EPS.value}
\title{Computes general statistics on ring-width series.}
\usage{
EPS.value(rwl, stc = c(5,2,1))
}
\arguments{
\item{rwl}{a data.frame with ring-width values}

\item{stc}{a vector of three integers giving the Site-Tree-Core mask. Defaults to c(5,2,1) and these three values should sum to eigth. The stc[1] gives the number of characters used to define the site code, stc[2] defines the tree mask and the core ids is given by the last element of the vector stc[3].}
}
\value{
A \code{"data.frame"} with the following values:
  \item{start}{the first year}
  \item{end}{the last year}
  \item{tree}{the number of trees}
  \item{core}{the number of cores}
  \item{n.tot}{the number of unique combinations of the input series (i.e., 1/2*n*[n-1])}
  \item{n.wt}{the total number of unique combinations of the within-tree series}
  \item{n.bt}{the total number of unique combinations of the between-tree series}
  \item{r.tot}{the mean of all correlation between different cores}
  \item{r.wt}{the mean of correlations between series from the same tree over all trees}
  \item{r.bt}{the mean interseries correlation between all series from different trees}
  \item{c.eff}{the effective number of cores}
  \item{r.eff}{the effective signal calculated as [rbar.bt / (rbar.wt + (1-rbar.wt) / c.eff)]}
  \item{eps}{the expressed population signal}
}
\description{
Compute general statistics on a data.frame of ring-width series.
}
\details{
This function is a changed version of the Andrew Bunn's rwi.stats function from the dplR package (Bunn, 2008).
}
\examples{
\dontshow{
 set.seed(1)
 rwl <- matrix(sample(1:1000,1000), ncol = 10, dimnames = list(c(1:100),1:10))
 rwl[49,] <- 100
 rwl[50,] <- 1
 rwl[51,] <- 100
 rwl <- as.rwl(rwl)
 EPS.value(rwl, stc = c(0, 8, 0))
 }
\dontrun{
data(co021, package = "dplR")
years <- as.integer(rownames(co021))
co021.subset <- subset(co021, subset = years >= 1900 & years <= 1950)
## remove the following series "645232","646107" and "646118"
co021.subset <- co021.subset[, !colnames(co021) \%in\% c("645232", "646107", "646118")]
EPS.value(co021.subset, stc = c(0, 8, 0))
}
}
\references{
Bunn, A. 2008. A dendrochronology program library in R (dplR). Dendrochronologia 26:115-124.

Cook, E.R., Kairiukstis, L.A. 1990. Methods of Dendrochronology: applications in the environmental sciences.  Kluwer Academic Publishers.
}
