% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diathorAll.R
\encoding{UTF-8}
\name{diaThorAll}
\alias{diaThorAll}
\title{Runs all the DiaThor functions in a pipeline}
\usage{
diaThorAll(
  species_df,
  isRelAb = FALSE,
  maxDistTaxa = 2,
  resultsPath,
  calculateguilds = TRUE,
  vandam = TRUE,
  vandamReports = TRUE,
  singleResult = TRUE,
  exportFormat = 3,
  exportName = "DiaThor_results",
  plotAll = TRUE,
  color = "#0073C2",
  updateDBC = TRUE
)
}
\arguments{
\item{species_df}{The data frame with your species data. Species as rows, Sites as columns. If empty, a dialog will prompt for a CSV file}

\item{isRelAb}{Boolean. If set to 'TRUE' it means that your species' data is the relative abundance of each species per site. If FALSE, it means that it the data corresponds to absolute densities. Default = FALSE}

\item{maxDistTaxa}{Integer. Number of characters that can differ in the species' names when compared to the internal database's name in the heuristic search. Default = 2}

\item{resultsPath}{String. Path to the output folder. If none specified (default), a dialog box will prompt to select it}

\item{calculateguilds}{Boolean. If set to 'TRUE' the percentage of abundance of each diatom guild will be calculated. Default = TRUE}

\item{vandam}{Boolean. If set to 'TRUE' the Van Dam classifications will be calculated in the Output. Default = TRUE}

\item{vandamReports}{Boolean. If set to 'TRUE' the detailed reports for the Van Dam classifications will be reported in the Output. Default = TRUE}

\item{singleResult}{Boolean. If set to 'TRUE' all results will go into a single output file. If FALSE, separate output files will be generated. Default = TRUE}

\item{exportFormat}{Integer. If = 1: only a CSV (external file) will be generated with the output matrices; 2: only an internal R dataframe will be generated; 3: both a CSV and an internal R dataframe are generated. Default = 3}

\item{exportName}{String. Prefix for the CSV exported file. Default = "DiaThor_results"}

\item{plotAll}{Boolean. If set to 'TRUE', plots will be generated for each Output in a PDF file. Default = TRUE}

\item{color}{Color code (hex). Default color for bar charts and lolipop plots. Default = "#0073C2"}

\item{updateDBC}{Boolean. If TRUE it will attempt to update the database from the DiatBarcode project, otherwise it will use the latest internal database. Default = TRUE}
}
\description{
The diaThorAll function is the master function of the package. It calculates all outputs from the data, and places them in the Output folder
The input file for the package is a dataframe or an external CSV file. Species should be listed as rows, with species' names in column 1 (column name should be "species")
The other columns (samples) have to contain the abundance of each species (relative or absolute) in each sample.
The first row of the file has to contain the headers with the sample names. Remember that a column named "species" is mandatory, containing the species' names
If a dataframe is not specified as a parameter (species_df), the package will show a dialog box to search for the CSV file
A second dialog box will help set up an Output folder, where all outputs from the package will be exported to (dataframes, CSV files, plots in PDF)
The package also downloads and installs a wrapper for the 'Diat.Barcode' project. Besides citing the DiaThor package, the Diat.Barcode project should also be cited, as follows:
\itemize{
\item Rimet, Frederic; Gusev, Evgenuy; Kahlert, Maria; Kelly, Martyn; Kulikovskiy, Maxim; Maltsev, Yevhen; Mann, David; Pfannkuchen, Martin; Trobajo, Rosa; Vasselon, Valentin; Zimmermann, Jonas; Bouchez, Agnès. 2018. "Diat.barcode, an open-access barcode library for diatoms". Scientific Reports,9, 15116. https://doi:10.15454/TOMBYZ
}
Sample data in the examples is taken from:
\itemize{
\item Nicolosi Gelis, María Mercedes; Cochero, Joaquín; Donadelli, Jorge; Gómez, Nora. 2020. "Exploring the use of nuclear alterations, motility and ecological guilds in epipelic diatoms as biomonitoring tools for water quality improvement in urban impacted lowland streams". Ecological Indicators, 110, 105951. https://doi:10.1016/j.ecolind.2019.105951
}
}
\examples{
\donttest{
# Example using sample data included in the package (sampleData):
data("diat_sampleData")
# In the example, a temporary directory will be used in resultsPath
allResults <- diaThorAll(diat_sampleData, resultsPath = tempdir())
}
}
\keyword{bioindicator}
\keyword{biotic}
\keyword{diatom}
\keyword{ecology}
