% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gini_decomp.R
\name{gini_decomp}
\alias{gini_decomp}
\title{Decomposition of the Gini coefficient}
\usage{
gini_decomp(x, z, weights = NULL)
}
\arguments{
\item{x}{a numeric vector containing at least non-negative elements.}

\item{z}{a factor containing the population sub groups.}

\item{weights}{an optional vector of weights of x to be used in the computation of
the decomposition. Should be NULL or a numeric vector.}
}
\value{
a list with the results of the decomposition and the parts used for the
decomposition, containing the following components:
   \item{gini_decomp}{a list containing the decomposition: gini_total (value of the gini
   coefficient of x), gini_within (value of within-group inequality), gini_between (value
   of between-group inequality) and gini_overlap (value of overlap in inequality)}
   \item{gini_group}{a list containing gini_group (the gini coefficients of the different
   subgroups) and gini_group_contribution(the contribution of the subgroups to the total
   within-group inequality: adds up to gini_within)}
   \item{gini_decomp}{a list containing the means of x: mean_total (value of the mean of x of
   all subgroups combined) and mean_group (value of the mean of x of the individual subgroups)
   inequality) and gini_between (value of between-group inequality)}
   \item{share_groups}{the distribution of the subgroups z }
   \item{share_income_groups}{the distribution of vector x by subgroups z }
   \item{number_cases}{a list containing the number of cases in total, by subgroup (weighted
   and unweighted): n_unweighted (total number of unweighted x), n_weighted (total number of
   weighted x), n_group_unweighted (number of unweighted x by subgroup z), n_group_unweighted
   (number of weighted x by subgroup z)}
}
\description{
Decomposes the Gini coefficient into population subgroups. Distinction is made
by between and within group inequality and an overlap (interaction) term.
}
\details{
The decomposition of the Gini coefficient by between and within group
inequality. In most cases there is an overlap of the distribution of both groups. Consequence
is that between and within group inequality doesn't add up to the total Gini coefficient. In
those cases there is an overlap term. Also referred to as interaction effect.

Within group inequality is calculated by using the Gini coefficient for each sub group. Between
group inequality by using the gini coefficient of the average of both sub groups.
}
\examples{
#Decomposition of the gini coefficient by level of education using Mexican Income data set
data(mex_inc_2008)
education_decomp <- gini_decomp(x=mex_inc_2008$income,z=mex_inc_2008$education,
weights=mex_inc_2008$factor)

#complete output
education_decomp

#Selected output: decomposition into between- and within-group inequality and overlap (interaction)
education_decomp["gini_decomp"]

}
\references{
Mookherjee, D. and A. Shorrocks (1982) A decomposition analysis of the trend in UK income
inequality, \emph{Economic Journal}, 92 (368), p. 886-902.

Cowell F. (2000) Measurement of Inequality. In Atkinson A. and Bourguignon F. (eds.) \emph{
Handbook of Income Distribution}. Amsterdam: Elsevier, p. 87-166.
}
\seealso{
\code{\link{mld_decomp}}
}
