% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R, R/plot_dirichletprocess.R
\name{plot.dirichletprocess}
\alias{plot.dirichletprocess}
\alias{plot_dirichletprocess_univariate}
\alias{plot_dirichletprocess_multivariate}
\title{Plot the Dirichlet process object}
\usage{
\method{plot}{dirichletprocess}(x, ...)

plot_dirichletprocess_univariate(
  x,
  likelihood = FALSE,
  single = TRUE,
  data_fill = "black",
  data_method = "density",
  data_bw = NULL,
  ci_size = 0.05,
  xgrid_pts = 100,
  quant_pts = 100,
  xlim = NA
)

plot_dirichletprocess_multivariate(x)
}
\arguments{
\item{x}{Dirichlet Process Object to plot}

\item{...}{Further arguments, currently ignored.}

\item{likelihood}{Logical, indicating whether to plot the likelihood from the
dpobj.}

\item{single}{Logical, indicating whether to draw the posterior from the last
iteration or use the full cluster sequence.}

\item{data_fill}{Passed to `fill` in the data geom, for example a color.
Defaults to "black".}

\item{data_method}{A string containing either "density" (default),
"hist"/"histogram", or "none". Data is plotted according to this method.}

\item{data_bw}{Bandwith to be passed either as the binwidth of
\code{geom_histogram}, or as the bw of \code{geom_density}.}

\item{ci_size}{Numeric, the interval size to use. Defaults to .05.}

\item{xgrid_pts}{Integer, the number of points on the x-axis to evaluate.}

\item{quant_pts}{Integer, the number of posterior functions to use to obtain
the posterior and its interval.}

\item{xlim}{Default NA. If a vector of length two, the limits on the x-axis
of the plot. If \code{NA} (default), the limits will be automatically
chosen.}
}
\value{
A ggplot object.
}
\description{
For a univariate Dirichlet process plot the density of the data with the
posterior distribution and credible intervals overlayed. For multivariate
data the first two columns of the data are plotted with the data points
coloured by their cluster labels. The additional arguments are not used for
multivariate data.
}
\examples{
dp <- DirichletProcessGaussian(c(rnorm(50, 2, .2), rnorm(60)))
dp <- Fit(dp, 100)
plot(dp)

plot(dp, likelihood = TRUE, data_method = "hist",
     data_fill = rgb(.5, .5, .8, .6), data_bw = .3)

}
