% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSignalParts.R
\name{getSignalParts}
\alias{getSignalParts}
\title{Signal parts}
\usage{
getSignalParts(seas.sig, candmin, candmax, years, months, jdays,
  for.year = NULL)
}
\arguments{
\item{seas.sig}{Seasonal signal as generated from DFFT methods}

\item{candmin}{numeric vector of possible ordinal days in which the predicted signal is lowest. 
This range need not be narrow, but a string of consecutive days should not include more than one local minimum. 
Used for calculating the high- and low-flow windows.}

\item{candmax}{numeric vector of possible ordinal days in which the predicted signal is highest. 
This range need not be narrow, but a string of consecutive days should not include more than one local maximum.}

\item{years}{A vector of years corrosponding to the seasonal signal values}

\item{months}{A vector of months corrosponding to the seasonal signal values}

\item{jdays}{A vector of julian days corrosponding to the seasonal signal values}

\item{for.year}{(optional) Calculate signal parts only for the given year in this argument.
If argument is omitted, all years are considered.}
}
\value{
Data frame containing following columns.
\tabular{ll}{
\code{year} \tab represents year \cr
\code{max.peak.index.all} \tab represents index value within the entire vector \cr
\code{max.peak.value} \tab represents value of max peak \cr
\code{highwind.start.index.all} \tab start index of high flow window within the entire vector \cr
\code{highwind.end.index.all} \tab end index of high flow window within the entire vector \cr
\code{lowwind.start.index.all} \tab start index of low flow window within the entire vector \cr
\code{lowwind.end.index.all} \tab end index of low flow window within the entire vector \cr
}
}
\description{
This function computes high flow and low flow window of seasonal signal, and the peak max
and peak min values.
}
\examples{
# load sample data
data("sycamore")
x = sycamore

# get streamflow object for the sample data
x.streamflow = asStreamflow(x)

# prepare baseline signal 
x.bl = prepareBaseline(x.streamflow)

# signal parts
x.sp = getSignalParts(x.bl$pred2, candmin = c(40:125), candmax = c(190:330),
                      years = x.streamflow$data$year, 
                      months = x.streamflow$data$month,
                      jdays = x.streamflow$data$jday)

}
