% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters.R
\name{frac_common_cov}
\alias{frac_common_cov}
\alias{frac_identity}
\alias{smoothness}
\title{Parameter objects for Regularized Discriminant Models}
\usage{
frac_common_cov(range = c(0, 1), trans = NULL)

frac_identity(range = c(0, 1), trans = NULL)

smoothness(range = c(0.5, 1.5), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\value{
A function with classes "quant_param" and "param"
}
\description{
\code{discrim_regularized()} describes the effect of \code{frac_common_cov()} and
\code{frac_identity()}. \code{smoothness()} is an alias for the \code{adjust} parameter in
\code{stats::density()}.
}
\details{
These parameters can modulate a RDA model to go between linear and quadratic
class boundaries.
}
\examples{
frac_common_cov()
}
