% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expandDist.R
\name{expandDist}
\alias{expandDist}
\title{Expanding a distance matrix given new data}
\usage{
expandDist(distA, A, B, method = "euclidean", diag = FALSE, upper = FALSE, p = 2)
}
\arguments{
\item{distA}{A "dist" object, representing the pairwise distance matrix between observations in matrix A, ideally computed via
the distance metric specified in this function. This requires manual check.}

\item{A}{A numeric matrix.}

\item{B}{A numeric matrix.}

\item{method}{A character string specifying the distance metric to use. Supported methods include
\code{"euclidean"}, \code{"manhattan"}, \code{"maximum"}, \code{"minkowski"}, \code{"cosine"}, and \code{"canberra"}.}

\item{diag}{A boolean value, indicating whether to display the diagonal entries.}

\item{upper}{A boolean value, indicating whether to display the upper triangular entries.}

\item{p}{A positive integer, required for computing Minkowski distance; by default p = 2 (i.e., Euclidean).}
}
\value{
A distance matrix of class "dist" for rbind(A,B).
}
\description{
Efficiently appends new "rows" to an existing "dist" object without explicitly recomputing a full pairwise distance matrix.
}
\details{
Expands an existing distance matrix of class "dist" for matrix A, given new data B,
without explicitly computing the distance matrix of rbind(A,B). This supports multiple commonly
used distance measures and is optimised for speed.

Row names are retained. If either rownames(A) or rownames(B) is null, as.character(1:(nrow(A)+nrow(B)))
will be used as row names instead.
}
\examples{

A = matrix(rnorm(100), nrow = 20)
B = matrix(rnorm(250), nrow = 50)
AB = rbind(A,B)
distA = fastDist(A)
v1 = as.vector(expandDist(distA, A, B))
v2 = as.vector(fastDist(AB))
all.equal(v1, v2)
}
\author{
Minh Long Nguyen \email{edelweiss611428@gmail.com}
}
