% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibull-probability.R
\name{ptailw}
\alias{ptailw}
\title{TailW Probability Function}
\usage{
ptailw(x, threshold, scale, shape)
}
\arguments{
\item{x}{Sample data.}

\item{threshold}{Minimum value of the tail.}

\item{scale}{Scale parameter.}

\item{shape}{Shape parameter.}
}
\value{
Gives the distribution function of the TailW. The length of the result is determined by the length of x.
}
\description{
This function computes the cumulative density function of the tailW with the input sample data.
\deqn{F(x,\alpha,\beta,\nu)=1-\exp(-\alpha(x+\nu)^\beta+\alpha\nu^\beta).}
}
\examples{
# Using the probability function to show the fitting.
samp <- rtailw(1000, 1, 2, 3)
emp_cdf <- ecdf(samp)(samp)
pars <- fittail(samp, dist = "TailW")
x_seq <- seq(min(samp), max(samp), length.out = 250)
p <- ptailw(x_seq, threshold = 1, scale = pars$scale, shape = pars$shape)
plot(samp, 1-emp_cdf, log = "y")
lines(x_seq, 1-p, col = "red")
}
\keyword{TailW}
