% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsl_join.R
\name{tsl_join}
\alias{tsl_join}
\title{Join Time Series Lists}
\usage{
tsl_join(..., na_action = "impute")
}
\arguments{
\item{...}{(required, time series lists) names of the time series lists to merge.}

\item{na_action}{(required, character) NA handling action. Available options are:
\itemize{
\item "impute" (default): NA cases are interpolated from neighbors as a function of time (see \code{\link[zoo:na.approx]{zoo::na.approx()}} and \code{\link[zoo:na.approx]{zoo::na.spline()}}).
\item "omit": rows with NA cases are removed.
}}
}
\value{
time series list
}
\description{
Joins an arbitrary of time series lists by name and time. Pairs of zoo objects are joined with \code{\link[zoo:merge.zoo]{zoo::merge.zoo()}}. Names that are not shared across all input TSLs are ignored, and observations with no matching time are filled with NA and then managed via \code{\link[=tsl_handle_NA]{tsl_handle_NA()}} depending on the value of the argument \code{na_action}.
}
\examples{

#generate two time series list to join
tsl_a <- tsl_simulate(
  n = 2,
  cols = 2,
  irregular = TRUE,
  seed = 1
)

#needs renaming
tsl_b <- tsl_simulate(
  n = 3,
  cols = 2,
  irregular = TRUE,
  seed = 2
) |>
  tsl_colnames_set(
    names = c("c", "d")
  )

#join
tsl <- tsl_join(
  tsl_a,
  tsl_b
)

#plot result
if(interactive()){
  tsl_plot(
    tsl = tsl
  )
}

}
\seealso{
Other tsl_management: 
\code{\link{tsl_burst}()},
\code{\link{tsl_colnames_clean}()},
\code{\link{tsl_colnames_get}()},
\code{\link{tsl_colnames_prefix}()},
\code{\link{tsl_colnames_set}()},
\code{\link{tsl_colnames_suffix}()},
\code{\link{tsl_count_NA}()},
\code{\link{tsl_diagnose}()},
\code{\link{tsl_handle_NA}()},
\code{\link{tsl_names_clean}()},
\code{\link{tsl_names_get}()},
\code{\link{tsl_names_set}()},
\code{\link{tsl_names_test}()},
\code{\link{tsl_ncol}()},
\code{\link{tsl_nrow}()},
\code{\link{tsl_repair}()},
\code{\link{tsl_subset}()},
\code{\link{tsl_time}()},
\code{\link{tsl_to_df}()}
}
\concept{tsl_management}
