asymptotics <- function(object, ...){
  if(!is(object, "distfreereg")) stop("'object' must be an object of class 'distfreereg'")
  test_mean <- object[["test_mean"]]
  if(is.null(test_mean)) stop("'object' must have a non-NULL 'test_mean' value")
  distfreereg_args <- as.list(getCall(object))[-1]
  distfreereg_args[["Y"]] <- NULL
  compare_args <- list(true_mean = test_mean)
  if(is.function(test_mean)) compare_args[["theta"]] <- object[["theta_hat"]]
  if(is.function(test_mean) || is(test_mean, "nls") || is(object[["model"]], "nls"))
    compare_args[["true_covariance"]] <- object[["covariance"]]
  true_method <- get_method(object)
  if(!is.null(true_method)){
    compare_args[["true_method"]] <- true_method
    compare_args[["true_method_args"]] <- distfreereg_args[["method_args"]]
  }
  if(!is.null(distfreereg_args[["X"]]))
    compare_args[["true_X"]] <- object[["data"]][["X"]]
  if(!is.null(distfreereg_args[["data"]]))
    compare_args[["true_data"]] <- object[["data"]][["data"]]
  compare_args <- c(distfreereg_args, compare_args, list(...))
  cdfr <- do.call(compare, args = compare_args)
  return(cdfr)
}
